% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_sources.R
\name{query_sources}
\alias{query_sources}
\title{List all known URL sources for a given Content URI}
\usage{
query_sources(
  id,
  registries = default_registries(),
  cols = c("source", "date"),
  ...
)
}
\arguments{
\item{id}{a content identifier}

\item{registries}{list of registries at which to register the URL}

\item{cols}{names of columns to keep. Default are \code{source} and \code{date}.  See details.}

\item{...}{additional arguments}
}
\value{
a data frame with all registration events when a URL or
a local path (including the local store) have contained the corresponding content.
}
\description{
List all known URL sources for a given Content URI
}
\details{
possible columns are (in order): \code{identifier}, \code{source}, \code{date},
\code{size}, \code{status}, \code{md5}, \code{sha1}, \code{sha256}, \code{sha384}, \code{sha512}
}
\examples{
\donttest{

id <- paste0("hash://sha256/9412325831dab22aeebdd",
             "674b6eb53ba6b7bdd04bb99a4dbb21ddff646287e37")
query_sources(id)

}

}
\seealso{
history register store
}
