% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history_url.R
\name{history_url}
\alias{history_url}
\alias{history_url,}
\alias{query_history}
\title{List all content identifiers that have been seen at a given URL}
\usage{
history_url(url, registries = default_registries(), ...)
}
\arguments{
\item{url}{A URL for a data file}

\item{registries}{list of registries at which to register the URL}

\item{...}{additional arguments}
}
\value{
a data frame with all content identifiers that have been seen
at a given URL.  If the URL is version-stable, this should be a single
identifier.  Note that if multiple identifiers are listed, older content
may no longer be available, though there is a chance it has been registered
to a different url and can be resolved with \link{sources}.
}
\description{
\link{history_url} is the complement of \link{sources}, in that it filters a table
of content identifier : url : date entries by the url.
}
\details{
\code{\link[=history_url]{history_url()}} only applies to registries that contain mutable URLs,
i.e. hash-archive and local registries which merely record the contents last
seen at any URL.  Such URLs may have the same or different content at a later
date, or may fail to resolve.  In contrast, archives such as DataONE or
Zenodo that resolve identifiers to source URLs control both the registry and
the content storage, and thus only report URLs where content is currently found.
While Download URLs from archives may move and old URLs may fail, a download URL
never has "history" of different content (e.g. different versions) served
from the same access URL.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}


\dontshow{ ## Real users won't use a temporary dir
Sys.setenv("CONTENTID_REGISTRIES" = tempdir())
Sys.setenv("CONTENTID_HOME" = tempdir())
}

\donttest{ 
history_url(paste0("https://zenodo.org/api/files/5967f986-b599-4492-9a08",
"-94ce32323dc2/vostok.icecore.co2"), 
registries = "https://hash-archive.carlboettiger.info")
}

\dontshow{ ## Real users won't use a temporary dir
Sys.unsetenv("CONTENTID_REGISTRIES")
Sys.unsetenv("CONTENTID_HOME")
} 
\dontshow{\}) # examplesIf}
}
\seealso{
sources
}
