% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve}
\alias{resolve}
\title{Resolve content from a content identifier}
\usage{
resolve(
  id,
  registries = default_registries(),
  verify = TRUE,
  store = FALSE,
  dir = content_dir(),
  ...
)
}
\arguments{
\item{id}{A content identifier, see \link{content_id}}

\item{registries}{list of registries at which to register the URL}

\item{verify}{logical, default \link{TRUE}. Should we verify that
content matches the requested hash?}

\item{store}{logical, should we add remotely downloaded copy to the local store?}

\item{dir}{path to the local store directory. Defaults to first local registry given to
the \code{registries} argument.}

\item{...}{additional arguments}
}
\description{
Requested content can be found at mutiple locations:
cached to disk, or available at one or more URLs.  This function
provides a mechanism to always return a single, local path to the
content requested, (provided the content identifier can be found in
at least one of the registries).
}
\details{
Local storage
is checked first as it will allow us to bypass downloading content
when a local copy is available. If no local copy is found but
one or more remote URLs are registered for the hash, downloads
from these will be attempted in order from most recent first.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{ ## Real users won't use a temporary dir
Sys.setenv("CONTENTID_REGISTRIES" = tempdir())
Sys.setenv("CONTENTID_HOME" = tempdir())
}
# ensure some content in local storage for testing purposes:
vostok_co2 <- system.file("extdata", "vostok.icecore.co2",
                          package = "contentid")
store(vostok_co2)

\donttest{
resolve(paste0(
 "hash://sha256/9412325831dab22aeebdd6",
 "74b6eb53ba6b7bdd04bb99a4dbb21ddff646287e37")
)
}
\dontshow{ ## Real users won't use a temporary dir
Sys.unsetenv("CONTENTID_REGISTRIES")
Sys.unsetenv("CONTENTID_HOME")
}

\dontshow{\}) # examplesIf}
}
\seealso{
query query_local query_remote
}
