% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/software-heritage.R
\name{retrieve_swh}
\alias{retrieve_swh}
\title{retrieve content from Software Heritage given a content identifier}
\usage{
retrieve_swh(id, host = "https://archive.softwareheritage.org")
}
\arguments{
\item{id}{a content identifier}

\item{host}{the domain name for the Software Heritage API}
}
\description{
retrieve content from Software Heritage given a content identifier
}
\examples{
\dontshow{if (has_resource("https://archive.softwareheritage.org")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

id <- paste0("hash://sha256/9412325831dab22aeebdd",
             "674b6eb53ba6b7bdd04bb99a4dbb21ddff646287e37")
retrieve_swh(id)

}
\dontshow{\}) # examplesIf}
}
\seealso{
\link{retrieve}, \link{sources_swh}
}
