% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{register}
\alias{register}
\title{register a URL with remote and/or local registries}
\usage{
register(url, registries = default_registries(), ...)
}
\arguments{
\item{url}{a URL for a data file (or list of URLs)}

\item{registries}{list of registries at which to register the URL}

\item{...}{additional arguments}
}
\value{
the \link[httr:response]{httr::response} object for the request (invisibly)
}
\description{
register a URL with remote and/or local registries
}
\details{
Local registries can be specified as one or more file paths
where local registries should be created.  Usually a given application
will want to register in only one local registry.  For most use cases,
the default registry should be sufficient.
}
\examples{


\dontshow{ ## Real users won't use a temporary dir
Sys.setenv("CONTENTID_REGISTRIES" = tempdir())
}
 
\donttest{

register(paste0("https://knb.ecoinformatics.org/knb/d1/mn/v2/object/",
"ess-dive-457358fdc81d3a5-20180726T203952542"))
}

\dontshow{ ## Real users won't use a temporary dir
Sys.unsetenv("CONTENTID_REGISTRIES")
}


}
