% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artifact.R
\name{Artifact}
\alias{Artifact}
\title{A Comet Artifact object}
\description{
Comet Artifacts allow keeping track of assets beyond any particular experiment. You can keep
track of Artifact versions, create many types of assets, manage them, and use them in any
step in your ML pipelines - from training to production deployment.

Artifacts live in a Comet Project, are identified by their name and version string number.
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables define
exp <- create_experiment()

# Create a Comet Artifact
artifact <- Artifact$new(artifact_name = "Artifact-Name", artifact_type = "Artifact-Type")
artifact$add("local-file")

exp$log_artifact(artifact)
exp$stop()
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Artifact-new}{\code{Artifact$new()}}
\item \href{#method-Artifact-get_artifact_name}{\code{Artifact$get_artifact_name()}}
\item \href{#method-Artifact-get_artifact_type}{\code{Artifact$get_artifact_type()}}
\item \href{#method-Artifact-get_artifact_version}{\code{Artifact$get_artifact_version()}}
\item \href{#method-Artifact-get_aliases}{\code{Artifact$get_aliases()}}
\item \href{#method-Artifact-get_metadata}{\code{Artifact$get_metadata()}}
\item \href{#method-Artifact-get_version_tags}{\code{Artifact$get_version_tags()}}
\item \href{#method-Artifact-get_assets}{\code{Artifact$get_assets()}}
\item \href{#method-Artifact-add}{\code{Artifact$add()}}
\item \href{#method-Artifact-add_remote}{\code{Artifact$add_remote()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-new"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-new}{}}}
\subsection{Method \code{new()}}{
Creates new \code{Artifact} object with provided parameters. After that,
the \code{Artifact} object can be used to save assets and can be logged
with an \code{\link{Experiment}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$new(
  artifact_name,
  artifact_type,
  artifact_version = NULL,
  aliases = NULL,
  metadata = NULL,
  version_tags = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{artifact_name}}{(Required) Artifact name.}

\item{\code{artifact_type}}{(Required) The artifact type, for example 'dataset'.}

\item{\code{artifact_version}}{The version number to create. If not provided,
a new version number will be created automatically.}

\item{\code{aliases}}{List of aliases. Some aliases to attach to the future Artifact
Version. The aliases list is normalized to remove duplicates.}

\item{\code{metadata}}{Some additional meta-data to attach to the future Artifact Version.}

\item{\code{version_tags}}{List of tags to be attached to the future Artifact Version.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-get_artifact_name"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-get_artifact_name}{}}}
\subsection{Method \code{get_artifact_name()}}{
Get the name of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$get_artifact_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-get_artifact_type"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-get_artifact_type}{}}}
\subsection{Method \code{get_artifact_type()}}{
Get the type of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$get_artifact_type()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-get_artifact_version"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-get_artifact_version}{}}}
\subsection{Method \code{get_artifact_version()}}{
Get the version of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$get_artifact_version()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-get_aliases"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-get_aliases}{}}}
\subsection{Method \code{get_aliases()}}{
Get the version of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$get_aliases()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Get the metadata of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$get_metadata()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-get_version_tags"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-get_version_tags}{}}}
\subsection{Method \code{get_version_tags()}}{
Get the list of tags of the artifact version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$get_version_tags()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-get_assets"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-get_assets}{}}}
\subsection{Method \code{get_assets()}}{
Get the list of assets of the artifact version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$get_assets()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-add"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-add}{}}}
\subsection{Method \code{add()}}{
Add a local asset to the current pending artifact object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$add(
  local_path,
  overwrite = FALSE,
  logical_path = NULL,
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{local_path}}{(Required) Either a file/directory path of the files you want to log}

\item{\code{overwrite}}{If \code{\link{TRUE}} will overwrite all existing assets with the same name.}

\item{\code{logical_path}}{A custom file name to be displayed. If not
provided the file name from the \code{local_path} argument will be used.}

\item{\code{metadata}}{Some additional data to attach to the asset.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artifact-add_remote"></a>}}
\if{latex}{\out{\hypertarget{method-Artifact-add_remote}{}}}
\subsection{Method \code{add_remote()}}{
Add a remote asset to the current pending artifact object. A Remote Asset is an asset but
its content is not uploaded and stored on Comet. Rather a link for its location is stored so
you can identify and distinguish between two experiment using different version of a dataset
stored somewhere else.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artifact$add_remote(
  uri,
  logical_path = NULL,
  overwrite = FALSE,
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{(Required) The remote asset location, there is no imposed format and it could be a
private link.}

\item{\code{logical_path}}{The "name" of the remote asset, could be a dataset
name, a model file name.}

\item{\code{overwrite}}{If \code{\link{TRUE}} will overwrite all existing assets with the same name.}

\item{\code{metadata}}{Some additional data to attach to the asset.}
}
\if{html}{\out{</div>}}
}
}
}
