% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorttools.R
\name{plotcuminc}
\alias{plotcuminc}
\title{Plots cumulative incidence rates}
\usage{
plotcuminc(ftime, fstatus, cencode, pop.length = 50, group, ...)
}
\arguments{
\item{ftime}{failure time variable}

\item{fstatus}{variable with distinct codes for different causes of failure and also a distinct code for censored observations}

\item{cencode}{value of fstatus variable which indicates the failure time is censored.}

\item{pop.length}{number of population sizes shown}

\item{group}{plots will be made for each group. If missing then treated as all one group}

\item{...}{additional parameters}
}
\value{
if missing group ggplot2 object or if group given named list of ggplot2 objects
}
\description{
Plots cumulative incidence rates
}
\note{
package cmprsk and ggplot2 are utilized
}
\examples{
set.seed(2)
ss <- rexp(100)
gg <- factor(sample(1:3,100,replace=TRUE),1:3,c('a','b','c'))
cc <- sample(0:2,100,replace=TRUE)
print(plotcuminc(ftime=ss,fstatus=cc,cencode=0))
print(plotcuminc(ftime=ss,fstatus=cc,cencode=0,group=gg))
}
\seealso{
\code{\link{survival}}  \code{\link{pyears}}
}
\author{
Jari Haukka \email{jari.haukka@helsinki.fi}
}
\keyword{survival}
