% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize.classcodes}
\alias{visualize.classcodes}
\title{Visualize classification scheme in web browser}
\usage{
\method{visualize}{classcodes}(x, group = NULL, show = TRUE, ...)
}
\arguments{
\item{x}{\link{classcodes} object or name of such object included in the package
(see \code{\link[=all_classcodes]{all_classcodes()}}).}

\item{group}{names (as character vector) of groups to visualize
(subset of \code{rownames(x)}). (All groups if \code{NULL}.)}

\item{show}{should a visualization be shown in the default web browser.
Set to \code{FALSE} to just retrieve a URL for later use.}

\item{...}{
  Arguments passed on to \code{\link[=set_classcodes]{set_classcodes}}
  \describe{
    \item{\code{regex}}{name of column with regular expressions to use for
classification.
\code{NULL} (default) uses \code{attr(obj, "regexpr")[1]}.}
  }}
}
\value{
URL to website with visualization (invisible)
}
\description{
Groups from a \code{classcodes} object are visualized by their regular expressions
in the default web browser.
The visualization does not give any details on group names, conditions or
weights but might be useful both for understanding of a classification scheme
in use, and during the creation and debugging of such.
}
\examples{

# The default behavior is to open a visualization in the default web browser
\dontrun{

 # How is depression classified according to Elixhauser?
 visualize("elixhauser", "depression")

 # Compare the two diabetes groups according to Charlson
 visualize("charlson",
   c("diabetes without complication", "diabetes complication"))

 # Is this different from the "Royal College of Surgeons classification?
 # Yes, there is only one group for diabetes
 visualize("charlson",
   c("diabetes without complication", "diabetes complication"),
   regex = "rcs"
 )

 # Show all groups from Charlson
 visualize("charlson")

 # It is also possible to visualize an arbitrary regular expression
 # from a character string
 visualize("I2([12]|52)")
}

 # The URL is always returned (invisable) but the visual display can
 # also be omitted
url <- visualize("hip_ae", show = FALSE)
url
}
\seealso{
Other classcodes: 
\code{\link{all_classcodes}()},
\code{\link{as.data.frame.classified}()},
\code{\link{classcodes}},
\code{\link{codebook}()},
\code{\link{print.classcodes}()},
\code{\link{print.classified}()},
\code{\link{set_classcodes}()},
\code{\link{summary.classcodes}()}
}
\concept{classcodes}
