\name{ggFusedHist}
\alias{ggFusedHist}
\title{
Fused histograms of ensemble and permutation results
}
\description{
The \code{ggFusedHist} function generates a histogram of the permutation results as generated by \code{\link{cfBuild}} and \code{\link{cfPermute}}.
}
\usage{
ggFusedHist(ensObj, permObj)
}
\arguments{
  \item{ensObj}{The classification ensemble (in the form of an R list) as generated by \code{\link{cfBuild}}}
  \item{permObj}{The permutation object as generated by \code{\link{cfPermute}}}
}
\seealso{
  \code{\link{cfBuild}}, \code{\link{cfPermute}}, \code{\link{ggEnsHist}}, \code{\link{ggPermHist}}
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]
               
# ** Use parallel = FALSE for execution in sequence **

# Ensemble construction
ensObj  <- cfBuild(inputData = irisData, inputClass = irisClass, bootNum = 5, 
                   ensNum = 2, parallel = FALSE)

# Permutation test
permObj <- cfPermute(irisData, irisClass, bootNum = 5, ensNum = 2, permNum = 2, 
                     parallel = FALSE)

ggFusedHist(ensObj, permObj)
}
}
\keyword{hplot}
