# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/lorem/el_GR/__init__.py

lorem_common_words_el_gr <- c(
  "\u03ac\u03c1\u03b1",
  "\u03ad\u03bd\u03b1",
  "\u03ad\u03bd\u03b1\u03c2",
  "\u03ad\u03be\u03b9",
  "\u03ad\u03c4\u03c3\u03b9",
  "\u03ad\u03c7\u03c9",
  "\u03ae\u03b4\u03b7",
  "\u03af\u03b4\u03b9\u03bf",
  "\u03b1\u03bd",
  "\u03b1\u03bd\u03ac",
  "\u03b1\u03c0\u03cc",
  "\u03b1\u03c2",
  "\u03b3\u03b9\u03b1",
  "\u03b4\u03b5",
  "\u03b4\u03b5\u03bd",
  "\u03b4\u03cd\u03bf",
  "\u03b5\u03b3\u03ce",
  "\u03b5\u03b4\u03ce",
  "\u03b5\u03ba\u03c4\u03cc\u03c2",
  "\u03b5\u03c0\u03af",
  "\u03b8\u03b1",
  "\u03ba\u03ac\u03c4\u03b9",
  "\u03ba\u03b1\u03b9",
  "\u03ba\u03b9",
  "\u03bc\u03ad\u03c7\u03c1\u03b9",
  "\u03bc\u03b1",
  "\u03bc\u03b1\u03c2",
  "\u03bc\u03b5",
  "\u03bc\u03b7",
  "\u03bc\u03b7\u03bd",
  "\u03bc\u03b9\u03b1",
  "\u03bc\u03b9\u03b1\u03c2",
  "\u03bc\u03bf\u03c5",
  "\u03bd\u03b1",
  "\u03bd\u03b1\u03b9",
  "\u03bf",
  "\u03bf\u03b9",
  "\u03c0\u03ac\u03bd\u03c4\u03b1",
  "\u03c0\u03ac\u03bd\u03c4\u03c9\u03c2",
  "\u03c0\u03b9\u03bf",
  "\u03c0\u03bb\u03ad\u03bf\u03bd",
  "\u03c0\u03bf\u03b9\u03b1",
  "\u03c0\u03bf\u03bb\u03cd",
  "\u03c0\u03bf\u03c5",
  "\u03c0\u03c9\u03c2",
  "\u03c3\u03b1\u03bd",
  "\u03c3\u03b1\u03c2",
  "\u03c3\u03b5",
  "\u03c3\u03bf\u03c5",
  "\u03c3\u03c4\u03b1",
  "\u03c3\u03c4\u03b7",
  "\u03c3\u03c4\u03b9\u03c2",
  "\u03c3\u03c4\u03bf",
  "\u03c4\u03b1",
  "\u03c4\u03b7",
  "\u03c4\u03b7\u03bd",
  "\u03c4\u03b7\u03c2",
  "\u03c4\u03b9",
  "\u03c4\u03b9\u03c2",
  "\u03c4\u03bf",
  "\u03c4\u03bf\u03bd",
  "\u03c4\u03bf\u03c5",
  "\u03c4\u03bf\u03c5\u03c2",
  "\u03c4\u03c9\u03bd",
  "\u03c9\u03c2",
  "\u03cc\u03c3\u03bf",
  "\u03cc\u03c4\u03b1\u03bd",
  "\u03cc\u03c4\u03b9",
  "\u03cc\u03c7\u03b9"
)

lorem_word_list_el_gr <- c(rep(lorem_common_words_el_gr, 2), c(
  "\u03ac\u03c1\u03b1",
  "\u03ad\u03bd\u03b1",
  "\u03ad\u03bd\u03b1\u03c2",
  "\u03ad\u03be\u03b9",
  "\u03ad\u03c4\u03c3\u03b9",
  "\u03ad\u03c7\u03c9",
  "\u03ae\u03b4\u03b7",
  "\u03af\u03b4\u03b9\u03bf",
  "\u03b1\u03bd",
  "\u03b1\u03bd\u03ac",
  "\u03b1\u03c0\u03cc",
  "\u03b1\u03c2",
  "\u03b3\u03b9\u03b1",
  "\u03b4\u03b5",
  "\u03b4\u03b5\u03bd",
  "\u03b4\u03cd\u03bf",
  "\u03b5\u03b3\u03ce",
  "\u03b5\u03b4\u03ce",
  "\u03b5\u03ba\u03c4\u03cc\u03c2",
  "\u03b5\u03c0\u03af",
  "\u03b8\u03b1",
  "\u03ba\u03ac\u03c4\u03b9",
  "\u03ba\u03b1\u03b9",
  "\u03ba\u03b9",
  "\u03bc\u03ad\u03c7\u03c1\u03b9",
  "\u03bc\u03b1",
  "\u03bc\u03b1\u03c2",
  "\u03bc\u03b5",
  "\u03bc\u03b7",
  "\u03bc\u03b7\u03bd",
  "\u03bc\u03b9\u03b1",
  "\u03bc\u03b9\u03b1\u03c2",
  "\u03bc\u03bf\u03c5",
  "\u03bd\u03b1",
  "\u03bd\u03b1\u03b9",
  "\u03bf",
  "\u03bf\u03b9",
  "\u03c0\u03ac\u03bd\u03c4\u03b1",
  "\u03c0\u03ac\u03bd\u03c4\u03c9\u03c2",
  "\u03c0\u03b9\u03bf",
  "\u03c0\u03bb\u03ad\u03bf\u03bd",
  "\u03c0\u03bf\u03b9\u03b1",
  "\u03c0\u03bf\u03bb\u03cd",
  "\u03c0\u03bf\u03c5",
  "\u03c0\u03c9\u03c2",
  "\u03c3\u03b1\u03bd",
  "\u03c3\u03b1\u03c2",
  "\u03c3\u03b5",
  "\u03c3\u03bf\u03c5",
  "\u03c3\u03c4\u03b1",
  "\u03c3\u03c4\u03b7",
  "\u03c3\u03c4\u03b9\u03c2",
  "\u03c3\u03c4\u03bf",
  "\u03c4\u03b1",
  "\u03c4\u03b7",
  "\u03c4\u03b7\u03bd",
  "\u03c4\u03b7\u03c2",
  "\u03c4\u03b9",
  "\u03c4\u03b9\u03c2",
  "\u03c4\u03bf",
  "\u03c4\u03bf\u03bd",
  "\u03c4\u03bf\u03c5",
  "\u03c4\u03bf\u03c5\u03c2",
  "\u03c4\u03c9\u03bd",
  "\u03c9\u03c2",
  "\u03cc\u03c3\u03bf",
  "\u03cc\u03c4\u03b1\u03bd",
  "\u03cc\u03c4\u03b9",
  "\u03cc\u03c7\u03b9",
  "\u03ac\u03c1\u03b1",
  "\u03ad\u03bd\u03b1",
  "\u03ad\u03bd\u03b1\u03c2",
  "\u03ad\u03be\u03b9",
  "\u03ad\u03c4\u03c3\u03b9",
  "\u03ad\u03c7\u03c9",
  "\u03ae\u03b4\u03b7",
  "\u03af\u03b4\u03b9\u03bf",
  "\u03b1\u03bd",
  "\u03b1\u03bd\u03ac",
  "\u03b1\u03c0\u03cc",
  "\u03b1\u03c2",
  "\u03b3\u03b9\u03b1",
  "\u03b4\u03b5",
  "\u03b4\u03b5\u03bd",
  "\u03b4\u03cd\u03bf",
  "\u03b5\u03b3\u03ce",
  "\u03b5\u03b4\u03ce",
  "\u03b5\u03ba\u03c4\u03cc\u03c2",
  "\u03b5\u03c0\u03af",
  "\u03b8\u03b1",
  "\u03ba\u03ac\u03c4\u03b9",
  "\u03ba\u03b1\u03b9",
  "\u03ba\u03b9",
  "\u03bc\u03ad\u03c7\u03c1\u03b9",
  "\u03bc\u03b1",
  "\u03bc\u03b1\u03c2",
  "\u03bc\u03b5",
  "\u03bc\u03b7",
  "\u03bc\u03b7\u03bd",
  "\u03bc\u03b9\u03b1",
  "\u03bc\u03b9\u03b1\u03c2",
  "\u03bc\u03bf\u03c5",
  "\u03bd\u03b1",
  "\u03bd\u03b1\u03b9",
  "\u03bf",
  "\u03bf\u03b9",
  "\u03c0\u03ac\u03bd\u03c4\u03b1",
  "\u03c0\u03ac\u03bd\u03c4\u03c9\u03c2",
  "\u03c0\u03b9\u03bf",
  "\u03c0\u03bb\u03ad\u03bf\u03bd",
  "\u03c0\u03bf\u03b9\u03b1",
  "\u03c0\u03bf\u03bb\u03cd",
  "\u03c0\u03bf\u03c5",
  "\u03c0\u03c9\u03c2",
  "\u03c3\u03b1\u03bd",
  "\u03c3\u03b1\u03c2",
  "\u03c3\u03b5",
  "\u03c3\u03bf\u03c5",
  "\u03c3\u03c4\u03b1",
  "\u03c3\u03c4\u03b7",
  "\u03c3\u03c4\u03b9\u03c2",
  "\u03c3\u03c4\u03bf",
  "\u03c4\u03b1",
  "\u03c4\u03b7",
  "\u03c4\u03b7\u03bd",
  "\u03c4\u03b7\u03c2",
  "\u03c4\u03b9",
  "\u03c4\u03b9\u03c2",
  "\u03c4\u03bf",
  "\u03c4\u03bf\u03bd",
  "\u03c4\u03bf\u03c5",
  "\u03c4\u03bf\u03c5\u03c2",
  "\u03c4\u03c9\u03bd",
  "\u03c9\u03c2",
  "\u03cc\u03c3\u03bf",
  "\u03cc\u03c4\u03b1\u03bd",
  "\u03cc\u03c4\u03b9",
  "\u03cc\u03c7\u03b9",
  "\u03ac\u03bb\u03b3\u03b5\u03b2\u03c1\u03b1",
  "\u03ac\u03c0\u03b5\u03b9\u03c1\u03b1",
  "\u03ac\u03c1\u03b1",
  "\u03ac\u03c1\u03b8\u03c1\u03c9\u03bd",
  "\u03ac\u03c4\u03bf\u03bc\u03bf",
  "\u03ad\u03b3\u03c1\u03b1\u03c8\u03b5\u03c2",
  "\u03ad\u03bb\u03b5\u03b3\u03c7\u03bf\u03c2",
  "\u03ad\u03be\u03b9",
  "\u03ad\u03c1\u03b8\u03b5\u03b9",
  "\u03ad\u03c3\u03c4\u03b5\u03b9\u03bb\u03b5",
  "\u03ad\u03c3\u03c4\u03b5\u03bb\u03bd\u03b5",
  "\u03ad\u03c4\u03bf\u03b9\u03bc\u03bf\u03c2",
  "\u03ad\u03c4\u03c3\u03b9",
  "\u03ad\u03c7\u03c9",
  "\u03ae\u03b4\u03b7",
  "\u03af\u03b4\u03b9\u03bf",
  "\u03b1\u03b3\u03bf\u03c1\u03ac\u03b6\u03bf\u03bd\u03c4\u03b1\u03c2",
  "\u03b1\u03b8\u03cc\u03c1\u03c5\u03b2\u03b5\u03c2",
  "\u03b1\u03ba\u03bf\u03cd\u03c3\u03b5\u03b9",
  "\u03b1\u03bb\u03b3\u03cc\u03c1\u03b9\u03b8\u03bc\u03bf\u03c5",
  "\u03b1\u03bd\u03b1\u03b3\u03ba\u03ac\u03b6\u03bf\u03bd\u03c4\u03b1\u03b9",
  "\u03b1\u03bd\u03b1\u03ba\u03bb\u03cd\u03c8\u03b5\u03b9\u03c2",
  "\u03b1\u03bd\u03b1\u03c6\u03ad\u03c1\u03bf\u03bd\u03c4\u03b1\u03b9",
  "\u03b1\u03bd\u03b1\u03c6\u03bf\u03c1\u03ac",
  "\u03b1\u03bd\u03b5\u03c0\u03b9\u03b8\u03cd\u03bc\u03b7\u03c4\u03b7",
  "\u03b1\u03bd\u03c4\u03b1\u03b3\u03c9\u03bd\u03b9\u03c3\u03c4\u03ae\u03c2",
  "\u03b1\u03bd\u03c4\u03b9\u03bb\u03ae\u03c6\u03b8\u03b7\u03ba\u03b1\u03bd",
  "\u03b1\u03bd\u03ce\u03b4\u03c5\u03bd\u03b7",
  "\u03b1\u03c0\u03af\u03c3\u03c4\u03b5\u03c5\u03c4\u03b1",
  "\u03b1\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03ba\u03c4\u03b7",
  "\u03b1\u03c0\u03b1\u03c1\u03b1\u03af\u03c4\u03b7\u03c4\u03bf",
  "\u03b1\u03c0\u03b1\u03c1\u03b1\u03c4\u03ae\u03c1\u03b7\u03c4\u03bf",
  "\u03b1\u03c0\u03bb\u03cc",
  "\u03b1\u03c0\u03bf\u03b4\u03b5\u03af\u03be\u03b5\u03b9\u03c2",
  "\u03b1\u03c0\u03bf\u03b8\u03b7\u03ba\u03b5\u03c5\u03c4\u03b9\u03ba\u03bf\u03cd",
  "\u03b1\u03c0\u03bf\u03ba\u03bb\u03b5\u03b9\u03c3\u03c4\u03b9\u03ba\u03bf\u03cd\u03c2",
  "\u03b1\u03c0\u03bf\u03bc\u03cc\u03bd\u03c9\u03c3\u03b7",
  "\u03b1\u03c0\u03bf\u03c3\u03c4\u03b7\u03b8\u03af\u03c3\u03b5\u03b9",
  "\u03b1\u03c0\u03bf\u03c6\u03ac\u03c3\u03b9\u03c3\u03b5",
  "\u03b1\u03c0\u03cc",
  "\u03b1\u03c0\u03cc\u03bb\u03b1\u03c5\u03c3\u03b5",
  "\u03b1\u03c1\u03ad\u03c3\u03b5\u03b9",
  "\u03b1\u03c1\u03c0\u03ac\u03b6\u03b5\u03b9\u03c2",
  "\u03b1\u03c1\u03c7\u03b5\u03af\u03b1",
  "\u03b1\u03c4\u03cc\u03bc\u03bf\u03c5",
  "\u03b1\u03c5\u03c4\u03ae\u03bd",
  "\u03b1\u03c5\u03c4\u03cc\u03c2",
  "\u03b1\u03c6\u03ae\u03c3\u03b5\u03b9\u03c2",
  "\u03b2\u03ac\u03b6\u03bf\u03bd\u03c4\u03b1\u03c2",
  "\u03b2\u03b1\u03b8\u03bc\u03cc",
  "\u03b2\u03b1\u03c3\u03b1\u03bd\u03af\u03b6\u03bf\u03c5\u03bd",
  "\u03b2\u03b3\u03ae\u03ba\u03b5",
  "\u03b2\u03b9\u03b1\u03c3\u03c4\u03b9\u03ba\u03ac",
  "\u03b2\u03b9\u03b2\u03bb\u03af\u03bf",
  "\u03b2\u03bf\u03c5\u03c4\u03ae\u03be\u03bf\u03c5\u03bd",
  "\u03b2\u03c1\u03af\u03c3\u03ba\u03bf\u03bd\u03c4\u03b1\u03b9",
  "\u03b3\u03ad\u03bb\u03b1\u03c3\u03b1\u03bd",
  "\u03b3\u03b5\u03b3\u03bf\u03bd\u03cc\u03c2",
  "\u03b3\u03b5\u03b9\u03c4\u03bf\u03bd\u03b9\u03ac\u03c2",
  "\u03b3\u03b5\u03cd\u03bc\u03b1\u03c4\u03bf\u03c2",
  "\u03b3\u03b9\u03b1",
  "\u03b3\u03b9\u03b1\u03c5\u03c4\u03cc",
  "\u03b3\u03bd\u03c9\u03c1\u03af\u03b6\u03bf\u03c5\u03bc\u03b5",
  "\u03b3\u03bd\u03c9\u03c3\u03c4\u03ae",
  "\u03b3\u03c1\u03ac\u03c8\u03b5\u03b9",
  "\u03b3\u03c1\u03b1\u03bc\u03bc\u03ad\u03c2",
  "\u03b3\u03c1\u03b1\u03bc\u03bc\u03ae",
  "\u03b3\u03c1\u03b1\u03bc\u03bc\u03ae\u03c2",
  "\u03b3\u03c1\u03b1\u03c6\u03b9\u03ba\u03ac",
  "\u03b4\u03af\u03bd\u03bf\u03bd\u03c4\u03b1\u03c2",
  "\u03b4\u03b5",
  "\u03b4\u03b5\u03af\u03be\u03b5\u03b9",
  "\u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03c9\u03bd",
  "\u03b4\u03b5\u03bd",
  "\u03b4\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03ae\u03c3\u03b5\u03b9\u03c2",
  "\u03b4\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03b5\u03af\u03c2",
  "\u03b4\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03b9\u03b1",
  "\u03b4\u03b9\u03ac\u03b2\u03b1\u03c3\u03b5",
  "\u03b4\u03b9\u03ac\u03c3\u03b7\u03bc\u03b1",
  "\u03b4\u03b9\u03b1\u03b4\u03af\u03ba\u03c4\u03c5\u03bf",
  "\u03b4\u03b9\u03b1\u03ba\u03bf\u03c0\u03ae",
  "\u03b4\u03b9\u03b1\u03ba\u03bf\u03c0\u03ae\u03c2",
  "\u03b4\u03b9\u03b1\u03ba\u03cc\u03c8\u03bf\u03c5\u03bc\u03b5",
  "\u03b4\u03b9\u03b1\u03c0\u03b9\u03c3\u03c4\u03ce\u03bd\u03b5\u03b9\u03c2",
  "\u03b4\u03b9\u03b1\u03c3\u03c6\u03b1\u03bb\u03af\u03b6\u03b5\u03c4\u03b1\u03b9",
  "\u03b4\u03b9\u03b1\u03c6\u03ae\u03bc\u03b9\u03c3\u03b7",
  "\u03b4\u03b9\u03b1\u03c7\u03b5\u03b9\u03c1\u03b9\u03c3\u03c4\u03ae\u03c2",
  "\u03b4\u03b9\u03b5\u03c5\u03b8\u03c5\u03bd\u03c4\u03ad\u03c2",
  "\u03b4\u03b9\u03bf\u03b9\u03ba\u03b7\u03c4\u03b9\u03ba\u03cc",
  "\u03b4\u03b9\u03bf\u03bb\u03b9\u03c3\u03b8\u03ae\u03c3\u03b5\u03b9\u03c2",
  "\u03b4\u03b9\u03bf\u03c1\u03b8\u03ce\u03c3\u03b5\u03b9",
  "\u03b4\u03b9\u03bf\u03c1\u03b8\u03ce\u03c3\u03b5\u03b9\u03c2",
  "\u03b4\u03bf\u03ba\u03b9\u03bc\u03ac\u03c3\u03b5\u03b9\u03c2",
  "\u03b4\u03bf\u03c5\u03bb\u03b5\u03cd\u03b5\u03b9",
  "\u03b4\u03bf\u03cd\u03bb\u03b5\u03c5\u03b5",
  "\u03b4\u03c5\u03c3\u03c4\u03c5\u03c7\u03ae\u03c2",
  "\u03b4\u03c5\u03c3\u03c4\u03c5\u03c7\u03ce\u03c2",
  "\u03b4\u03c9\u03c1\u03bf\u03b4\u03bf\u03ba\u03b7\u03b8\u03bf\u03cd\u03bd",
  "\u03b4\u03cd\u03bf",
  "\u03b5\u03af\u03c7\u03b1\u03bc\u03b5",
  "\u03b5\u03b3\u03ce",
  "\u03b5\u03b4\u03ce",
  "\u03b5\u03b9\u03b4\u03b9\u03ba\u03ac",
  "\u03b5\u03b9\u03ba\u03cc\u03bd\u03b5\u03c2",
  "\u03b5\u03ba\u03b4\u03cc\u03c3\u03b5\u03b9\u03c2",
  "\u03b5\u03ba\u03b5\u03af\u03bd\u03bf\u03c5",
  "\u03b5\u03ba\u03b8\u03ad\u03c3\u03b5\u03b9\u03c2",
  "\u03b5\u03ba\u03c4\u03b5\u03bb\u03ad\u03c3\u03b5\u03b9",
  "\u03b5\u03ba\u03c4\u03b5\u03bb\u03ad\u03c3\u03b5\u03b9\u03c2",
  "\u03b5\u03ba\u03c4\u03b5\u03bb\u03b5\u03af\u03c4\u03b1\u03b9",
  "\u03b5\u03ba\u03c4\u03cc\u03c2",
  "\u03b5\u03bb\u03ad\u03b3\u03c7\u03bf\u03c5",
  "\u03b5\u03bd\u03c4\u03bf\u03bb\u03ad\u03c2",
  "\u03b5\u03be\u03b1\u03ba\u03bf\u03bb\u03bf\u03c5\u03b8\u03b5\u03af",
  "\u03b5\u03be\u03b1\u03c1\u03c4\u03ac\u03c4\u03b1\u03b9",
  "\u03b5\u03be\u03bf\u03c1\u03b3\u03b9\u03c3\u03c4\u03b9\u03ba\u03ac",
  "\u03b5\u03c0\u03af",
  "\u03b5\u03c0\u03b5\u03bd\u03b4\u03c5\u03c4\u03ae\u03c2",
  "\u03b5\u03c0\u03b5\u03be\u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1",
  "\u03b5\u03c0\u03b9\u03b4\u03b9\u03bf\u03c1\u03b8\u03ce\u03c3\u03b5\u03b9\u03c2",
  "\u03b5\u03c0\u03b9\u03b4\u03b9\u03cc\u03c1\u03b8\u03c9\u03c3\u03b7",
  "\u03b5\u03c0\u03b9\u03c3\u03c4\u03c1\u03ad\u03c6\u03bf\u03c5\u03bd",
  "\u03b5\u03c0\u03b9\u03c7\u03b5\u03af\u03c1\u03b9\u03c3\u03b7",
  "\u03b5\u03c1\u03b3\u03ac\u03c3\u03c4\u03b7\u03ba\u03b5",
  "\u03b5\u03c1\u03b3\u03b1\u03b6\u03cc\u03bc\u03b5\u03bd\u03bf\u03b9",
  "\u03b5\u03c1\u03b3\u03b1\u03b6\u03cc\u03bc\u03b5\u03bd\u03c9\u03bd",
  "\u03b5\u03c1\u03b3\u03b1\u03bb\u03b5\u03af\u03c9\u03bd",
  "\u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2",
  "\u03b5\u03c1\u03b3\u03bf\u03c3\u03c4\u03b1\u03c3\u03af\u03bf\u03c5",
  "\u03b5\u03c1\u03c9\u03c4\u03ae\u03c3\u03b5\u03b9\u03c2",
  "\u03b5\u03c1\u03ce\u03c4\u03b7\u03c3\u03b7",
  "\u03b5\u03c3\u03c9\u03c4\u03b5\u03c1\u03b9\u03ba\u03ce\u03bd",
  "\u03b5\u03c4\u03b1\u03b9\u03c1\u03b5\u03af\u03b5\u03c2",
  "\u03b5\u03c5\u03ba\u03bf\u03bb\u03cc\u03c4\u03b5\u03c1\u03bf",
  "\u03b5\u03c6\u03b1\u03bc\u03bf\u03c1\u03b3\u03ae\u03c2",
  "\u03b5\u03c6\u03b1\u03c1\u03bc\u03bf\u03b3\u03ae",
  "\u03b5\u03c6\u03b1\u03c1\u03bc\u03bf\u03b3\u03ae\u03c2",
  "\u03b6\u03b7\u03c4\u03ae\u03c3\u03b5\u03b9\u03c2",
  "\u03b7\u03bc\u03ad\u03c1\u03b1",
  "\u03b8\u03ad\u03bb\u03b5\u03b9\u03c2",
  "\u03b8\u03ad\u03bc\u03b1",
  "\u03b8\u03ad\u03bc\u03b1\u03c4\u03b1",
  "\u03b8\u03c5\u03bc\u03ac\u03bc\u03b1\u03b9",
  "\u03b9\u03b4\u03b9\u03b1\u03af\u03c4\u03b5\u03c1\u03b1",
  "\u03ba\u03ac\u03bd\u03b5",
  "\u03ba\u03ac\u03bd\u03b5\u03b9\u03c2",
  "\u03ba\u03ac\u03c4\u03b9",
  "\u03ba\u03b1\u03b9",
  "\u03ba\u03b1\u03bb\u03cd\u03c4\u03b5\u03c1\u03bf",
  "\u03ba\u03b1\u03bd\u03ad\u03bd\u03b1\u03c2",
  "\u03ba\u03b1\u03bd\u03b5\u03af\u03c2",
  "\u03ba\u03b1\u03bd\u03cc\u03bd\u03b1",
  "\u03ba\u03b1\u03c4\u03b1\u03bb\u03ac\u03b8\u03bf\u03c2",
  "\u03ba\u03b5\u03b9\u03bc\u03ad\u03bd\u03c9\u03bd",
  "\u03ba\u03b9",
  "\u03ba\u03bb\u03c0",
  "\u03ba\u03bf\u03b9\u03c4\u03ac\u03b6\u03bf\u03bd\u03c4\u03b1\u03c2",
  "\u03ba\u03c1\u03b1\u03c4\u03ac\u03b5\u03b9",
  "\u03ba\u03c1\u03b1\u03c4\u03ae\u03c3\u03bf\u03c5\u03bd",
  "\u03ba\u03cc\u03bb\u03c0\u03b1",
  "\u03ba\u03cc\u03c8\u03b5\u03b9\u03c2",
  "\u03ba\u03cd\u03ba\u03bb\u03bf",
  "\u03ba\u03ce\u03b4\u03b9\u03ba\u03ac\u03c2",
  "\u03ba\u03ce\u03b4\u03b9\u03ba\u03b1",
  "\u03bb\u03ad\u03b5\u03b9",
  "\u03bb\u03af\u03b3\u03bf",
  "\u03bb\u03b1\u03bc\u03b2\u03ac\u03bd\u03bf\u03c5\u03bd",
  "\u03bb\u03b5\u03c2",
  "\u03bb\u03b5\u03c4\u03c0\u03ac",
  "\u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf",
  "\u03bb\u03bf\u03b9\u03c0\u03cc\u03bd",
  "\u03bc\u03ac\u03b8\u03b5",
  "\u03bc\u03ac\u03bb\u03bb\u03bf\u03bd",
  "\u03bc\u03ac\u03c4\u03c3\u03bf",
  "\u03bc\u03ad\u03b3\u03b9\u03c3\u03c4\u03b7",
  "\u03bc\u03ad\u03c1\u03bf\u03c2",
  "\u03bc\u03ad\u03c3\u03b7\u03c2",
  "\u03bc\u03ad\u03c7\u03c1\u03b9",
  "\u03bc\u03b1\u03b3\u03b9\u03ba\u03ac",
  "\u03bc\u03b5\u03c1\u03b9\u03ba\u03bf\u03cd\u03c2",
  "\u03bc\u03b5\u03c4\u03b1\u03b3\u03bb\u03c9\u03c4\u03af\u03c3\u03b5\u03b9",
  "\u03bc\u03b5\u03c4\u03b1\u03b3\u03bb\u03c9\u03c4\u03b9\u03c3\u03c4\u03ae\u03c2",
  "\u03bc\u03b5\u03c4\u03b1\u03c6\u03c1\u03b1\u03c3\u03c4\u03ae\u03c2",
  "\u03bc\u03b5\u03c4\u03c1\u03ac\u03b5\u03b9",
  "\u03bc\u03b5\u03c4\u03c1\u03ae\u03c3\u03b5\u03b9\u03c2",
  "\u03bc\u03b7\u03c7\u03b1\u03bd\u03ae\u03c2",
  "\u03bc\u03c0\u03bf\u03c1\u03bf\u03cd\u03c3\u03b5\u03c2",
  "\u03bc\u03c0\u03bf\u03c5\u03bd",
  "\u03bd\u03ad\u03b1",
  "\u03bd\u03ad\u03bf",
  "\u03bd\u03ad\u03bf\u03c5",
  "\u03bd\u03ad\u03c9\u03bd",
  "\u03bd\u03b9\u03c1\u03b2\u03ac\u03bd\u03b1",
  "\u03bd\u03cc\u03bc\u03b9\u03b6\u03b5\u03c2",
  "\u03be\u03ad\u03c7\u03b1\u03c3\u03b5",
  "\u03bf\u03c1\u03af\u03c3\u03c4\u03b5",
  "\u03c0\u03ac\u03bd\u03c4\u03b1",
  "\u03c0\u03ac\u03bd\u03c4\u03c9\u03c2",
  "\u03c0\u03ac\u03c1\u03b1",
  "\u03c0\u03ac\u03c1\u03b5\u03b9\u03c2",
  "\u03c0\u03ae\u03c1\u03b5",
  "\u03c0\u03b1\u03af\u03be\u03bf\u03c5\u03bd",
  "\u03c0\u03b1\u03af\u03c1\u03bd\u03b5\u03b9",
  "\u03c0\u03b1\u03af\u03c1\u03bd\u03bf\u03c5\u03bd",
  "\u03c0\u03b1\u03ba\u03ad\u03c4\u03c9\u03bd",
  "\u03c0\u03b1\u03c1\u03ac\u03b3\u03bf\u03bd\u03c4\u03b5\u03c2",
  "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1",
  "\u03c0\u03b1\u03c1\u03b1\u03b3\u03c9\u03b3\u03b9\u03ba\u03ae\u03c2",
  "\u03c0\u03b1\u03c1\u03b1\u03b4\u03bf\u03c4\u03ad\u03bf\u03c5",
  "\u03c0\u03b1\u03c1\u03b1\u03b4\u03ce\u03c3\u03b5\u03b9\u03c2",
  "\u03c0\u03b1\u03c1\u03b1\u03c0\u03ac\u03bd\u03c9",
  "\u03c0\u03b5\u03b4\u03af\u03b1",
  "\u03c0\u03b5\u03c1\u03af\u03c0\u03bf\u03c5",
  "\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03bf\u03bd",
  "\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03bf\u03bd\u03c4\u03bf\u03c2",
  "\u03c0\u03b5\u03c1\u03b9\u03b5\u03c7\u03cc\u03bc\u03b5\u03bd\u03b1",
  "\u03c0\u03b5\u03c1\u03b9\u03bc\u03ad\u03bd\u03bf\u03c5\u03bd",
  "\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b5\u03c2",
  "\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b7",
  "\u03c0\u03b5\u03c2",
  "\u03c0\u03b5\u03c4\u03ac\u03bd\u03b5",
  "\u03c0\u03b5\u03c4\u03ac\u03be\u03b1\u03bc\u03b5",
  "\u03c0\u03b5\u03c4\u03bf\u03cd\u03bd",
  "\u03c0\u03b7\u03b3\u03b1\u03af\u03bf\u03c5",
  "\u03c0\u03b9\u03bf",
  "\u03c0\u03bb\u03ad\u03bf\u03bd",
  "\u03c0\u03bf\u03b9\u03b1",
  "\u03c0\u03bf\u03bb\u03cd",
  "\u03c0\u03bf\u03c3\u03bf\u03c3\u03c4\u03cc",
  "\u03c0\u03bf\u03c5",
  "\u03c0\u03c1\u03bf\u03b2\u03bb\u03b7\u03bc\u03b1\u03c4\u03b9\u03ba\u03ae",
  "\u03c0\u03c1\u03bf\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b9\u03c3\u03c4\u03ad\u03c2",
  "\u03c0\u03c1\u03bf\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03b9\u03c3\u03c4\u03ae\u03c2",
  "\u03c0\u03c1\u03bf\u03ba\u03b1\u03bb\u03b5\u03af\u03c2",
  "\u03c0\u03c1\u03bf\u03ba\u03cd\u03c0\u03c4\u03bf\u03c5\u03bd",
  "\u03c0\u03c1\u03bf\u03c3\u03b5\u03ba\u03c4\u03b9\u03ba\u03ac",
  "\u03c0\u03c1\u03bf\u03c3\u03b8\u03ad\u03c3\u03b5\u03b9",
  "\u03c0\u03c1\u03bf\u03c3\u03bb\u03ac\u03bc\u03b2\u03b1\u03bd\u03b5\u03c2",
  "\u03c0\u03c1\u03bf\u03c3\u03bf\u03c7\u03ae",
  "\u03c0\u03c1\u03bf\u03c3\u03c0\u03b1\u03b8\u03ae\u03c3\u03b5\u03b9\u03c2",
  "\u03c0\u03c1\u03bf\u03c3\u03c0\u03b1\u03b8\u03bf\u03cd\u03bd",
  "\u03c0\u03c1\u03bf\u03ca\u03cc\u03bd\u03c4\u03b1",
  "\u03c0\u03c1\u03cc\u03c3\u03bb\u03b7\u03c8\u03b7",
  "\u03c0\u03c1\u03ce\u03c4\u03b7\u03c2",
  "\u03c0\u03c1\u03ce\u03c4\u03bf",
  "\u03c0\u03c1\u03ce\u03c4\u03bf\u03b9",
  "\u03c0\u03cc\u03c1\u03c4\u03b5\u03c2",
  "\u03c1\u03bf\u03ae",
  "\u03c1\u03bf\u03c5\u03c4\u03af\u03bd\u03b1",
  "\u03c1\u03c9\u03c4\u03ac\u03b5\u03b9",
  "\u03c1\u03c9\u03c4\u03ae\u03c3\u03b5\u03b9",
  "\u03c3\u03af\u03b3\u03bf\u03c5\u03c1\u03bf\u03c2",
  "\u03c3\u03b7\u03bc\u03b1\u03bd\u03c4\u03b9\u03ba\u03cc",
  "\u03c3\u03b7\u03bc\u03b1\u03bd\u03c4\u03b9\u03ba\u03cc\u03c2",
  "\u03c3\u03b7\u03bc\u03b5\u03af\u03b1",
  "\u03c3\u03ba\u03b5\u03c6\u03c4\u03b5\u03af\u03c2",
  "\u03c3\u03c0\u03af\u03c4\u03b9",
  "\u03c3\u03c4\u03ad\u03bb\u03bd\u03bf\u03bd\u03c4\u03ac\u03c2",
  "\u03c3\u03c4\u03ae\u03bb\u03b5\u03c2",
  "\u03c3\u03c4\u03b1\u03bc\u03b1\u03c4\u03ac\u03c2",
  "\u03c3\u03c4\u03c1\u03b1\u03b2\u03ac",
  "\u03c3\u03c5\u03b3\u03b3\u03c1\u03b1\u03c6\u03ae\u03c2",
  "\u03c3\u03c5\u03b3\u03b3\u03c1\u03b1\u03c6\u03b5\u03af\u03c2",
  "\u03c3\u03c5\u03b3\u03ba\u03b5\u03bd\u03c4\u03c1\u03c9\u03bc\u03ad\u03bd\u03bf\u03b9",
  "\u03c3\u03c5\u03b3\u03c7\u03c1\u03cc\u03bd\u03c9\u03c2",
  "\u03c3\u03c5\u03b3\u03c7\u03c9\u03bd\u03b5\u03c5\u03c4\u03b5\u03af",
  "\u03c3\u03c5\u03bd\u03ac\u03b4\u03b5\u03bb\u03c6\u03bf\u03c2",
  "\u03c3\u03c5\u03bd\u03ad\u03c7\u03b5\u03b9\u03b1",
  "\u03c3\u03c5\u03bd\u03b5\u03bd\u03c4\u03b5\u03cd\u03be\u03b5\u03b9\u03c2",
  "\u03c3\u03c5\u03bd\u03b5\u03c7\u03ce\u03c2",
  "\u03c3\u03c5\u03bd\u03b7\u03b8\u03af\u03b6\u03bf\u03c5\u03bd",
  "\u03c3\u03c7\u03b5\u03b4\u03b9\u03b1\u03c3\u03c4\u03ae\u03c2",
  "\u03c3\u03c9\u03c3\u03c4\u03ac",
  "\u03c4\u03ad\u03bb\u03b5\u03b9\u03bf\u03b9",
  "\u03c4\u03b1",
  "\u03c4\u03b1\u03be\u03b9\u03bd\u03bf\u03bc\u03b5\u03af",
  "\u03c4\u03b5\u03ba\u03bc\u03b7\u03c1\u03b9\u03ce\u03bd\u03b5\u03b9",
  "\u03c4\u03b5\u03bb\u03b5\u03b9\u03ce\u03c3\u03b5\u03b9",
  "\u03c4\u03b5\u03c3\u03c3\u03b1\u03c1\u03ce\u03bd",
  "\u03c4\u03bf\u03c0\u03b9\u03ba\u03ad\u03c2",
  "\u03c4\u03c1\u03ad\u03be\u03b5\u03b9",
  "\u03c4\u03c1\u03cc\u03c0\u03bf",
  "\u03c4\u03c1\u03cc\u03c0\u03bf\u03b9",
  "\u03c4\u03cd\u03c0\u03bf\u03c5",
  "\u03c4\u03cd\u03c0\u03bf\u03c5\u03c2",
  "\u03c5\u03c0\u03b7\u03c1\u03b5\u03c3\u03af\u03b1",
  "\u03c5\u03c0\u03bf\u03c8\u03ae\u03c6\u03b9\u03bf",
  "\u03c5\u03c8\u03b7\u03bb\u03cc\u03c4\u03b5\u03c1\u03b7",
  "\u03c5\u03cc\u03c1\u03ba\u03b7",
  "\u03c6\u03af\u03bb\u03bf\u03c2",
  "\u03c6\u03b1\u03b9\u03bd\u03cc\u03bc\u03b5\u03bd\u03bf",
  "\u03c6\u03b1\u03ba\u03ad\u03bb\u03bf\u03c5\u03c2",
  "\u03c6\u03c1\u03ac\u03c3\u03b7",
  "\u03c7\u03ac\u03bf\u03c2",
  "\u03c7\u03b1\u03bc\u03b7\u03bb\u03cc\u03c2",
  "\u03c7\u03b1\u03c1\u03b1\u03ba\u03c4\u03b7\u03c1\u03b9\u03c3\u03c4\u03b9\u03ba\u03cc",
  "\u03c7\u03b1\u03c1\u03b1\u03ba\u03c4\u03b7\u03c1\u03b9\u03c3\u03c4\u03b9\u03ba\u03ce\u03bd",
  "\u03c7\u03b1\u03c1\u03c4\u03b9\u03bf\u03cd",
  "\u03c7\u03b5\u03b9\u03c1\u03cc\u03c4\u03b5\u03c1\u03b1",
  "\u03c7\u03c1\u03b5\u03b9\u03ac\u03b6\u03bf\u03bd\u03c4\u03b1\u03b9",
  "\u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03af\u03b7\u03c3\u03ad",
  "\u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03b9\u03bf\u03cd\u03bd\u03c4\u03b1\u03bd",
  "\u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03b9\u03bf\u03cd\u03c3\u03b5\u03c2",
  "\u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03b9\u03ce\u03bd\u03c4\u03b1\u03c2",
  "\u03c7\u03c1\u03bf\u03bd\u03bf\u03b4\u03b9\u03b1\u03b3\u03c1\u03ac\u03bc\u03bc\u03b1\u03c4\u03b1",
  "\u03c7\u03c1\u03bf\u03bd\u03bf\u03b4\u03b9\u03b1\u03b3\u03c1\u03ac\u03bc\u03bc\u03b1\u03c4\u03bf\u03c2",
  "\u03c7\u03c1\u03cc\u03bd\u03bf\u03c5",
  "\u03c7\u03ce\u03c1\u03bf\u03c5",
  "\u03c9\u03c1\u03b1\u03af\u03bf",
  "\u03cd\u03c8\u03bf\u03c2",
  "\u03ce\u03c1\u03b1"
))

#' Lorem provider Greek (Greece)
#'
#' Methods for Lorem Ipsum generation.
#' Lorem Ipsum is a placeholder text commonly used to demonstrate the visual
#' form of a document or a typeface without relying on meaningful content.
#' @family el
#' @family GR
#' @export
#' @examples
#' x <- LoremProvider_el_GR$new()
#' x$word()
#' x$words(3)
#' x$words(6)
#' x$sentence()
#' x$paragraph()
#' x$paragraphs(3)
#' cat(x$paragraphs(6), sep = "\n")
#' x$text(19)
#' x <- LoremProvider_el_GR$new(word_connector = " --- ")
#' x$paragraph(4)
LoremProvider_el_GR <- R6::R6Class(
  inherit = LoremProvider,
  "LoremProvider_el_GR",
  private = list(
    word_list = lorem_word_list_el_gr,
    locale_ = "el_GR"
  )
)
