% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/who-nrvess.r
\name{who_nrevss}
\alias{who_nrevss}
\title{Retrieve WHO/NREVSS Surveillance Data}
\usage{
who_nrevss(region = c("national", "hhs", "census", "state"), years = NULL)
}
\arguments{
\item{region}{one of "\code{national}", "\code{hhs}", "\code{census}", or "\code{state}"}

\item{years}{a vector of years to retrieve data for (i.e. \code{2014} for CDC
flu season 2014-2015). CDC has data for this API going back to 1997.
Default value (\code{NULL}) means retrieve \strong{all} years. NOTE: if you
happen to specify a 2-digit season value (i.e. \code{57} == 2017-2018)
the function is smart enough to retrieve by season ID vs convert that
to a year.}
}
\value{
list of data frames identified by
\itemize{
\item \code{combined_prior_to_2015_16}
\item \code{public_health_labs}
\item \code{clinical_labs}
}
}
\description{
The CDC FluView Portal provides in-season and past seasons' national, regional,
and state-level outpatient illness and viral surveillance data from both
ILINet (Influenza-like Illness Surveillance Network) and WHO/NREVSS
(National Respiratory and Enteric Virus Surveillance System).
}
\details{
This function retrieves current and historical WHO/NREVSS surveillance data for
the identified region.
}
\note{
HHS, Census and State data retrieval is not as "instantaneous" as their ILINet
counterparts.\cr\cr
Also, beginning for the 2015-16 season, reports from public health and clinical
laboratories are presented separately in the weekly influenza update. This is
the reason why a list of data frames is returned.\cr\cr
\strong{ALSO} The new CDC API seems to be missing some public health lab data fields.
}
\examples{
\dontrun{
national_who <- who_nrevss("national")
hhs_who <- who_nrevss("hhs")
census_who <- who_nrevss("census")
state_who <- who_nrevss("state")
}
}
\references{
\itemize{
\item \href{https://gis.cdc.gov/grasp/fluview/fluportaldashboard.html}{CDC FluView Portal}
\item \href{https://wwwn.cdc.gov/ilinet/}{ILINet Portal} (Login required)
\item \href{https://www.cdc.gov/surveillance/nrevss/index.html}{WHO/NREVSS}
}
}
