% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plspath.r
\name{plspath}
\alias{plspath}
\title{Estimation of pls-path models}
\usage{
plspath(dat, B, indicatorx, indicatory, modex = "A", modey = "A",
  maxiter = 100, stdev = FALSE)
}
\arguments{
\item{dat}{(n,p)-matrix, the values of the manifest variables.
The columns must be arranged in that way that the components of refl are (absolutely) increasing}

\item{B}{(q,q) lower triangular matrix describing the interrelations of the latent variables:
b_ij= 1 regression coefficient of eta_j in the regression relation in which eta_i is 
b_ij= 0 if eta_i does not depend on eta_j in a direct way  (b_ii = 0 !)}

\item{indicatorx}{(p1,1) vector indicating with which exogenous composite the x-indicators are related.}

\item{indicatory}{(p2,1) vector indicating with which endogenous composite the y-indicators are related.
The components of the indicators must be increasing.}

\item{modex}{equals "A" or "B" , the mode for this block of indicators}

\item{modey}{equals "A" or "B" , the mode for this block of indicators}

\item{maxiter}{Scalar, maximal number of iterations}

\item{stdev}{Boolean Should the standard deviations of the estimates be computed by bootstrap?}
}
\value{
out list wih components
    \tabular{ll}{
         Bhat \tab (q,q) lower triangular matrix with the estimated coefficients of the structural model \cr 
         eta \tab (n,q)-matrix, the scores of the latent variables \cr
         w \tab vector of length p of weights for constructing the latent variables \cr
         lambdahat \tab vector of length p with the loadings  \cr
         resa \tab (n,?) matrix of residuals from outer model  \cr
         resi \tab (n,?) matrix of residuals from inner model  \cr
         R2 \tab vector with the coefficients of determination for all regression equations of the structural model \cr
         iter \tab number of iterations used   \cr
         ret \tab scalar, return code:  \cr
             \tab  0 normal convergence  \cr
             \tab  1 limit of iterations attained, probably without convergence  \cr
         sdev.beta  \tab (q,q) matrix, the standard deviations of path coefficients (when stdev = TRUE) \cr
         sdev.lambda \tab vector, the standard deviations of loadings (when stdev = TRUE)  
         }
}
\description{
\code{plspath} estimates pls path models using the classical approach formulated in Lohmueller.
}
\examples{
data(mobi250)
refl <- c(1, 1, 1, 4, 4, 4, 2, 2, 2, 3, 3, 5, 5, 5, 6, 6, 6, 7, 1, 1, 4, 4, 4, 4)  
o <- order(refl)
dat <- mobi250[,o]
dat <- dat[,-ncol(dat)]
refl <- refl[o][-length(refl)] 
indicatorx <- refl[1:5]
indicatory <- refl[-c(1:5)] - 1
B <- matrix(c(0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
              0,1,1,0,0,0,0,1,1,1,0,0,1,0,0,0,1,0),6,6,byrow=TRUE)  
out <- plspath(dat,B,indicatorx,indicatory,modex="A",modey="A")

}
