% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gscals.r
\name{gscals}
\alias{gscals}
\title{Estimating GSC models belonging to scenarios reflective-reflective, formative-reflective and formative-formative}
\usage{
gscals(dat, B, indicatorx, indicatory, loadingx = FALSE, loadingy = FALSE,
  maxiter = 200, biascor = FALSE)
}
\arguments{
\item{dat}{(n,p)-matrix, the values of the manifest variables.
The columns must be arranged in that way that the components of refl are (absolutely) increasing.}

\item{B}{(q,q) lower triangular matrix describing the interrelations of the latent variables:
b_ij = 1 regression coefficient of eta_j in the regression relation in which eta_i is the depend variable
b_ij = 0 if eta_i does not depend on eta_j in a direct way  (b_ii = 0 !)}

\item{indicatorx}{vector describing with which exogenous composite the X-variables are connected}

\item{indicatory}{vector describing with which endogenous composite the Y-variables are connected}

\item{loadingx}{logical TRUE when there are loadings for the X-variables in the model}

\item{loadingy}{logical TRUE when there are loadings for the Y-variables in the model}

\item{maxiter}{Scalar, maximal number of iterations}

\item{biascor}{Boolean, FALSE if no bias correction is done, TRUE if parametric bootstrap bias correction is  done.}
}
\value{
out list with components
       \tabular{ll}{
         Bhat \tab (q,q) lower triangular matrix with the estimated coefficients of the structural model \cr
         What \tab (n,q) matrix of weights for constructing the composites  \cr
         lambdahat \tab vector of length p with the loadings  or 0 \cr
         iter \tab number of iterations used   \cr
         fehl \tab maximal difference of parameter estimates for the last and second last iteration \cr
         composit \tab the data matrix of the composites \cr
         resid \tab the data matrix of the residuals of the structural model \cr
         S \tab the covariance matrix of the manifest variables \cr
         ziel \tab sum of squared residuals for the final sum \cr
         fit \tab The value of the fit criterion \cr
         R2 \tab vector with the coefficients of determination for all regression equations of the structural model
        }
}
\description{
\code{gscals} estimates GSC models  alternating least squares.
This leads to estimations of weights for the composites and an overall fit measure.
}
\examples{
data(mobi250)
ind <- c(1, 1, 1, 4, 4, 4, 2, 2, 2, 3, 3, 5, 5, 5, 6, 6, 6, 7, 1, 1, 4, 4, 4, 4) 
o <- order(ind)
indicatorx <- c(1,1,1,1,1)
indicatory <- c(1, 1, 1, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5)   
dat <- mobi250[,o]
dat <- dat[,-ncol(dat)]
B <- matrix(c(0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
              0,1,1,0,0,0,0,1,1,1,0,0,1,0,0,0,1,0),6,6,byrow=TRUE)
out <- gscals(dat,B,indicatorx,indicatory,loadingx=TRUE,loadingy=TRUE,maxiter=200,biascor=FALSE)

}
