% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bali.R
\name{balinese_date}
\alias{balinese_date}
\alias{as_balinese}
\title{Balinese Pawukon calendar dates}
\usage{
balinese_date(
  luang = integer(),
  dwiwara = integer(),
  triwara = integer(),
  caturwara = integer(),
  pancawara = integer(),
  sadwara = integer(),
  saptawara = integer(),
  asatawara = integer(),
  sangawara = integer(),
  dasawara = integer()
)

as_balinese(date)
}
\arguments{
\item{luang}{A numeric vector}

\item{dwiwara}{A numeric vector}

\item{triwara}{A numeric vector}

\item{caturwara}{A numeric vector}

\item{pancawara}{A numeric vector}

\item{sadwara}{A numeric vector}

\item{saptawara}{A numeric vector}

\item{asatawara}{A numeric vector}

\item{sangawara}{A numeric vector}

\item{dasawara}{A numeric vector}

\item{date}{A vector of dates on some calendar.}
}
\value{
A balinese vector object
}
\description{
The Balinese calendar repeats every 210 days. It has 10 concurrent
weeks, of lengths 1, 2, ..., 10 days. The 210 day cycles are unnumbered,
so there is no way to convert a Balinese date into a unique date on
another calendar.
}
\examples{
gregorian_date(2025, 6, 1:10) |>
  as_balinese()
}
\seealso{
\link{kajeng_keliwon}
}
