% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_pegel_online.R
\name{pegel_online_measurements}
\alias{pegel_online_measurements}
\title{Get Pegel-Online measurements}
\usage{
pegel_online_measurements(
  station,
  timeseries,
  start = NULL,
  end = NULL,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{station}{Station UUID, name, or number.}

\item{timeseries}{Timeseries shortname.}

\item{start}{Start timestamp in ISO 8601.}

\item{end}{End timestamp in ISO 8601.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with measurements.

Includes \code{timestamp_time} as POSIXct in Europe/Berlin.
}
\description{
Get Pegel-Online measurements
}
\details{
Returns measurement values for a station timeseries. Timestamps must be
ISO 8601 strings. Official docs: https://pegel-online.api.bund.dev.
}
\examples{
\dontrun{
stations <- pegel_online_stations(params = list(limit = 1))
pegel_online_measurements(stations$uuid[[1]], "W",
  start = "2024-01-01T00:00:00Z",
  end = "2024-01-02T00:00:00Z"
)
}

}
\seealso{
\code{\link[=pegel_online_timeseries]{pegel_online_timeseries()}} for metadata and
\code{\link[=pegel_online_measurements_plot]{pegel_online_measurements_plot()}} for PNG plots.
}
