% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_eco_visio.R
\name{eco_visio_data}
\alias{eco_visio_data}
\title{Get Eco-Visio counter measurement data}
\usage{
eco_visio_data(
  id_organisme,
  id_pdc,
  interval,
  flow_ids,
  begin = NULL,
  end = NULL,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{id_organisme}{Organization ID.}

\item{id_pdc}{Counter ID.}

\item{interval}{Aggregation interval (1-6: 1=15min, 2=hours, 3=days, 4=weeks,
5=months, 6=years).}

\item{flow_ids}{Practice IDs (semicolon-separated string or character vector).}

\item{begin}{Optional start date (Date or "YYYY-MM-DD" string).}

\item{end}{Optional end date (Date or "YYYY-MM-DD" string).}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with measurement data.

Includes \code{date_time} as POSIXct in Europe/Berlin.
}
\description{
Get Eco-Visio counter measurement data
}
\details{
Returns measurement data for a specific counter. The \code{flow_ids} parameter
specifies which traffic types to include (e.g., pedestrians, cyclists).
Use \code{\link[=eco_visio_counters]{eco_visio_counters()}} to discover available counters and their flow IDs.
}
\examples{
\dontrun{
# Get daily data for a counter
eco_visio_data(
  id_organisme = 4586,
  id_pdc = 100125331,
  interval = 4,
  flow_ids = "101125331"
)
}

}
\seealso{
\code{\link[=eco_visio_counters]{eco_visio_counters()}} to list available counters.
}
