% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_list.R
\name{bs_new_list}
\alias{bs_new_list}
\title{Create a list}
\usage{
bs_new_list(
  name,
  purpose,
  description,
  avatar,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{name}{Character. Display name for list.}

\item{purpose}{Purpose of the list. One of \code{'modlist'}, \code{'curatelist'}, or \code{'referencelist'}}

\item{description}{Optional character. Description of the list.}

\item{avatar}{Optional character. Path to image to use as avatar. PNG or JPEG recommended.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of list information
}
\description{
Create a list
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/list.json}{graph/list.json (2024-12-01)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/defs.json}{graph/defs.json (2024-12-01)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2023-11-25)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_new_list(name = 'test list bskyr', purpose = 'curatelist')
bs_new_list(name = 'test list bskyr w avatar',
  description = 'to be deleted, just for testing bskyr',
  avatar = fs::path_package('bskyr', 'man/figures/logo.png'),
  purpose = 'curatelist')
\dontshow{\}) # examplesIf}
}
\concept{record}
