% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-accessors.R
\name{br_predict}
\alias{br_predict}
\title{Predict method for breg objects}
\usage{
br_predict(obj, newdata = NULL, idx = NULL, type = NULL)
}
\arguments{
\item{obj}{A \code{breg} object with fitted models.}

\item{newdata}{Optional data frame for predictions. If NULL, uses original data.}

\item{idx}{Model index, an integer or string.}

\item{type}{Type of prediction. For Cox models: "lp" (linear predictor, default)
or "risk" (relative risk). For other models: "response" (default) or "link".}
}
\value{
Typically, a numeric vector of predictions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Generate predictions from fitted models in a \code{breg} object.
For Cox regression models, returns linear predictors (log relative hazard).
For other models, returns predicted values.
}
\examples{
# Cox regression example
if (requireNamespace("survival", quietly = TRUE)) {
  lung <- survival::lung |> dplyr::filter(ph.ecog != 3)
  mds <- br_pipeline(
    lung,
    y = c("time", "status"),
    x = c("age", "ph.ecog"),
    x2 = "sex",
    method = "coxph"
  )
  scores <- br_predict(mds)
  head(scores)
}
}
\seealso{
Other accessors: 
\code{\link{accessors}},
\code{\link{br_diagnose}()}
}
\concept{accessors}
