% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KL_bounds.R
\name{KL_bounds}
\alias{KL_bounds}
\title{Bounds for the KL-divergence}
\usage{
KL_bounds(ci, delta)
}
\arguments{
\item{ci}{object of class \code{CI}.}

\item{delta}{multiplicative variation coefficient for the entry of the covariance matrix given in \code{entry}.}
}
\value{
A dataframe including the KL-divergence bound for each co-variation scheme (model-preserving and standard) and every entry of the covariance matrix. For variations leading to non-positive semidefinite matrix, the dataframe includes a \code{NA}.
}
\description{
Computation of the bounds of the KL-divergence for variations of each parameter of a \code{CI} object.
}
\details{
Let \eqn{\Sigma} be the covariance matrix of a Gaussian Bayesian network with \eqn{n} vertices.
Let \eqn{D} and \eqn{\Delta} be  variation matrices acting additively on \eqn{\Sigma}. Let also \eqn{\tilde\Delta} be a model-preserving co-variation matrix.
Denote with \eqn{Y} and \eqn{\tilde{Y}} the original and the perturbed random vectors. Then for a standard sensitivity analysis
\deqn{KL(\tilde{Y}||Y)\leq 0.5n\max\left\{f(\lambda_{\max}(D\Sigma^{-1})),f(\lambda_{\min}(D\Sigma^{-1}))\right\}}
whilst for a model-preserving one
\deqn{KL(\tilde{Y}||Y)\leq 0.5n\max\left\{f(\lambda_{\max}(\tilde\Delta\circ\Delta)),f(\lambda_{\min}(\tilde\Delta\circ\Delta))\right\}}
where \eqn{\lambda_{\max}} and \eqn{\lambda_{\min}} are the largest and the smallest eigenvalues, respectively, \eqn{f(x)=\ln(1+x)-x/(1+x)} and \eqn{\circ} denotes the Schur or element-wise product.
}
\examples{
KL_bounds(synthetic_ci,1.05)


}
\references{
C. Görgen & M. Leonelli (2020), Model-preserving sensitivity analysis for families of Gaussian distributions.  Journal of Machine Learning Research, 21: 1-32.
}
\seealso{
\code{\link{KL.CI}}, \code{\link{KL.CI}}
}
