% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influential_obs.R
\name{influential_obs}
\alias{influential_obs}
\title{Influential observations}
\usage{
influential_obs(dag, df, alpha = "default")
}
\arguments{
\item{dag}{an object of class \code{bn} from the \code{bnlearn} package}

\item{df}{a base R style dataframe}

\item{alpha}{single integer. By default, the number of max levels in \code{df}}
}
\value{
A vector including the influence of each observation.
}
\description{
Influence of a single observation to the global monitor
}
\details{
Consider a Bayesian network over variables \eqn{Y_1,\dots,Y_m} and suppose a dataset \eqn{(\boldsymbol{y}_1,\dots,\boldsymbol{y}_n)} has been observed, where \eqn{\boldsymbol{y}_i=(y_{i1},\dots,y_{im})} and \eqn{y_{ij}} is the i-th observation of the j-th variable. Define \eqn{\boldsymbol{y}_{-i}=(\boldsymbol{y}_1,\dots,\boldsymbol{y}_{i-1},\boldsymbol{y}_{i+1},\dots,\boldsymbol{y}_n)}.
The influence of an observation to the global monitor is defined as
\deqn{|\log(p(\boldsymbol{y}_1,\dots,\boldsymbol{y}_n)) - \log(p(\boldsymbol{y}_{-i}))|.}
High values of this index denote observations that highly contribute to the likelihood of the model.
}
\examples{
influential_obs(chds_bn, chds[1:100,], 3)

}
\seealso{
\code{\link{influential_obs}}, \code{\link{node_monitor}}, \code{\link{seq_node_monitor}}, \code{\link{seq_pa_ch_monitor}}
}
