% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blaster.R
\name{read_fasta}
\alias{read_fasta}
\title{Reads the contents of nucleotide or protein FASTA file into a dataframe.}
\usage{
read_fasta(
  filename,
  filter = "",
  non_standard_chars = "error",
  alphabet = "nucleotide"
)
}
\arguments{
\item{filename}{A string specifying the name of the FASTA file to be imported.}

\item{filter}{An optional string specifying a sequence motif for sequence filtering.
Only keeps those sequences containing this motif. Also splits the
matched sequences and provides the split parts in two additional columns.}

\item{non_standard_chars}{A string specifying instructions for handling non-standard
nucleotide or amino acid characters. Options include 'remove',
'ignore' or throw an 'error'. Defaults to 'error'.}

\item{alphabet}{A string specifying the query and database alphabet: 
'nucleotide' or 'protein'. Defaults to 'nucleotide'.}
}
\value{
A dataframe containing FASTA ids (Id column) and sequences (Seq column).
        If 'filter' is specified, the split sequences are stored in additional columns
        Part1 and Part2.
}
\description{
Reads the contents of nucleotide or protein FASTA file into a dataframe.
}
\examples{

query <- system.file("extdata", "query.fasta", package = "blaster")

query <- read_fasta(filename = query)

}
