% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.R
\name{lm_plot}
\alias{lm_plot}
\title{Create a Plot with Linear Regression and Confidence/Prediction Intervals}
\arguments{
\item{lm_model}{A simple linear regression model object created by \code{lm()}.}

\item{conf.level}{A numeric value indicating the confidence level for the
confidence interval bands and prediction interval bands. Default is 0.95.}

\item{install_packages}{Logical, indicating whether required packages should
be automatically installed if not already available. Default is TRUE.}
}
\value{
A \code{ggplot2} plot object featuring the observations,
the simple linear regression line, the confidence interval bands, and
the prediction interval bands.
}
\description{
Generates a \code{ggplot2} plot that includes the observed data, a simple linear
regression line, and both confidence and prediction interval bands.
}
\examples{
# Example dataset
data <- data.frame(
  x = rnorm(100, mean = 50, sd = 10),
  y = 3 + 0.5 * rnorm(100, mean = 50, sd = 10) + rnorm(100)
)

# Run a regression model
my_model <- lm(y~x, data)

# Create plot with regression line, confidence limits, and prediction limits
lm_plot(my_model)

# Customize plot labels
lm_plot(my_model) + xlab("Your x-axis label") + ylab("Your y-axis label")
}
