% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIOMOD_LoadModels.R
\name{BIOMOD_LoadModels}
\alias{BIOMOD_LoadModels}
\title{Load species distribution models built with \pkg{biomod2}}
\usage{
BIOMOD_LoadModels(
  bm.out,
  full.name = NULL,
  PA = NULL,
  run = NULL,
  algo = NULL,
  merged.by.PA = NULL,
  merged.by.run = NULL,
  merged.by.algo = NULL,
  filtered.by = NULL
)
}
\arguments{
\item{bm.out}{a \code{\link{BIOMOD.models.out}} or \code{\link{BIOMOD.ensemble.models.out}} 
object that can be obtained with the \code{\link{BIOMOD_Modeling}} or 
\code{\link{BIOMOD_EnsembleModeling}} functions}

\item{full.name}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing model names to be kept, must be either \code{all} or a 
sub-selection of model names that can be obtained with the \code{\link{get_built_models}} 
function}

\item{PA}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing pseudo-absence set to be loaded, must be among \code{PA1}, 
\code{PA2}, \code{...}, \code{allData}}

\item{run}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing repetition set to be loaded, must be among \code{RUN1}, 
\code{RUN2}, \code{...}, \code{allRun}}

\item{algo}{(\emph{optional, default} \code{NULL}) \cr 
A \code{character} containing algorithm to be loaded, must be either 
\code{ANN}, \code{CTA}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{SRE}, \code{XGBOOST}}

\item{merged.by.PA}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing merged pseudo-absence set to be loaded, must be among \code{PA1}, 
\code{PA2}, \code{...}, \code{mergedData}}

\item{merged.by.run}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing merged repetition set to be loaded, must be among \code{RUN1}, 
\code{RUN2}, \code{...}, \code{mergedRun}}

\item{merged.by.algo}{(\emph{optional, default} \code{NULL}) \cr 
A \code{character} containing merged algorithm to be loaded, must be among 
\code{ANN}, \code{CTA}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{SRE}, \code{XGBOOST}, \code{mergedAlgo}}

\item{filtered.by}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing evaluation metric selected to filter single models to build the 
ensemble models, must be among \code{POD}, \code{FAR}, \code{POFD}, \code{SR}, 
\code{ACCURACY}, \code{BIAS}, \code{ROC}, \code{TSS}, \code{KAPPA}, \code{OR}, 
\code{ORSS}, \code{CSI}, \code{ETS}, \code{BOYCE}, \code{MPA}}
}
\value{
A \code{vector} containing the names of the loaded models.
}
\description{
This function loads individual models built with \code{\link{BIOMOD_Modeling}} 
or \code{\link{BIOMOD_EnsembleModeling}} functions.
}
\details{
This function might be of particular use to load models and make response plot analyses. \cr \cr

Running the function providing only \code{bm.out} argument will load all models built by the 
\code{\link{BIOMOD_Modeling}} or \code{\link{BIOMOD_EnsembleModeling}} function, but a 
subselection of models can be done using the additional arguments (\code{full.name}, \code{PA}, 
\code{run}, \code{algo}, \code{merged.by.PA}, \code{merged.by.run}, \code{merged.by.algo}, 
\code{filtered.by}).
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

# ---------------------------------------------------------------
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                       expl.var = myExpl,
                                       resp.xy = myRespXY,
                                       resp.name = myRespName)

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      CV.strategy = 'random',
                                      CV.nb.rep = 2,
                                      CV.perc = 0.8,
                                      OPT.strategy = 'bigboss',
                                      metric.eval = c('TSS','ROC'),
                                      var.import = 3,
                                      seed.val = 42)
}


# ---------------------------------------------------------------
# Loading some models built
BIOMOD_LoadModels(bm.out = myBiomodModelOut, algo = 'RF')


}
\seealso{
\code{\link{BIOMOD_Modeling}}, \code{\link{BIOMOD_EnsembleModeling}}

Other Main functions: 
\code{\link{BIOMOD_EnsembleForecasting}()},
\code{\link{BIOMOD_EnsembleModeling}()},
\code{\link{BIOMOD_FormatingData}()},
\code{\link{BIOMOD_Modeling}()},
\code{\link{BIOMOD_Projection}()},
\code{\link{BIOMOD_RangeSize}()}
}
\author{
Damien Georges
}
\concept{Main functions}
