% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_audit.R
\name{plot_confounder_sensitivity}
\alias{plot_confounder_sensitivity}
\title{Plot confounder sensitivity}
\usage{
plot_confounder_sensitivity(
  fit,
  confounders = NULL,
  metric = NULL,
  min_n = 10,
  coldata = NULL,
  numeric_bins = 4,
  learner = NULL
)
}
\arguments{
\item{fit}{LeakFit.}

\item{confounders}{Character vector of columns in `coldata` to evaluate.}

\item{metric}{Metric name to compute within each stratum.}

\item{min_n}{Minimum samples per stratum to display.}

\item{coldata}{Optional data.frame of sample metadata.}

\item{numeric_bins}{Number of quantile bins for numeric confounders.}

\item{learner}{Optional character scalar. When predictions include multiple
learners, selects the learner to summarize.}
}
\value{
A list containing the sensitivity table and a ggplot object.
}
\description{
Shows performance metrics across confounder strata to assess sensitivity to
batch/study effects. Requires ggplot2.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  set.seed(42)
  df <- data.frame(
    subject = rep(1:15, each = 2),
    outcome = factor(rep(c(0, 1), 15)),
    batch = factor(rep(c("A", "B", "C"), 10)),
    x1 = rnorm(30),
    x2 = rnorm(30)
  )
  splits <- make_split_plan(df, outcome = "outcome",
                            mode = "subject_grouped", group = "subject",
                            v = 3, progress = FALSE)
  custom <- list(
    glm = list(
      fit = function(x, y, task, weights, ...) {
        stats::glm(y ~ ., data = as.data.frame(x),
                   family = stats::binomial(), weights = weights)
      },
      predict = function(object, newdata, task, ...) {
        as.numeric(stats::predict(object, newdata = as.data.frame(newdata),
                                  type = "response"))
      }
    )
  )
  fit <- fit_resample(df, outcome = "outcome", splits = splits,
                      learner = "glm", custom_learners = custom,
                      metrics = "auc", refit = FALSE, seed = 1)
  plot_confounder_sensitivity(fit, confounders = "batch", coldata = df)
}

}
