% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry.R
\name{bid_ingest_telemetry}
\alias{bid_ingest_telemetry}
\title{Ingest telemetry data and identify UX friction points}
\usage{
bid_ingest_telemetry(path, format = NULL, thresholds = list())
}
\arguments{
\item{path}{File path to telemetry data (SQLite database or JSON log file)}

\item{format}{Optional format specification ("sqlite" or "json"). If NULL,
auto-detected from file extension.}

\item{thresholds}{Optional list of threshold parameters:
- unused_input_threshold: percentage of sessions below which input is
considered unused (default: 0.05)
- delay_threshold_seconds: seconds of delay considered problematic
(default: 30)
- error_rate_threshold: percentage of sessions with errors considered
problematic (default: 0.1)
- navigation_threshold: percentage of sessions visiting a page below
which it's considered underused (default: 0.2)
- rapid_change_window: seconds within which multiple changes indicate
confusion (default: 10)
- rapid_change_count: number of changes within window to flag as
confusion (default: 5)}
}
\value{
A hybrid object of class c("bid_issues", "list") containing bid_stage objects
for each identified issue in the "Notice" stage. The object includes:
\item{Legacy list}{Named list of bid_stage objects (e.g., "unused_input_region", "delayed_interaction")}
\item{issues_tbl}{Attached tidy tibble with issue metadata}
\item{flags}{Global telemetry flags as named list}
\item{created_at}{Timestamp when object was created}

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Use as_tibble() to access the tidy issues data, bid_flags() to extract flags,
    and legacy list access for backward compatibility.
}\if{html}{\out{</div>}}
}
\description{
This function ingests telemetry data from shiny.telemetry output (SQLite or
JSON) and automatically identifies potential UX issues, translating them into
BID framework Notice stages. It returns a hybrid object that is backward-compatible
as a list of Notice stages while also providing enhanced functionality with
tidy tibble access and flags extraction.
}
\examples{
\dontrun{
# Analyze SQLite telemetry database
issues <- bid_ingest_telemetry("telemetry.sqlite")

# Analyze JSON log with custom thresholds
issues <- bid_ingest_telemetry(
  "telemetry.log",
  format = "json",
  thresholds = list(
    unused_input_threshold = 0.1,
    delay_threshold_seconds = 60
  )
)

# Use results in BID workflow
if (length(issues) > 0) {
  # Take first issue and continue with BID process
  interpret_result <- bid_interpret(
    previous_stage = issues[[1]],
    central_question = "How can we improve user engagement?"
  )
}
}

}
