% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\name{edge_rolling}
\alias{edge_rolling}
\title{Rolling Estimates of Bid-Ask Spreads from Open, High, Low, and Close Prices}
\usage{
edge_rolling(open, high, low, close, width, sign = FALSE, na.rm = FALSE)
}
\arguments{
\item{open}{numeric vector of open prices.}

\item{high}{numeric vector of high prices.}

\item{low}{numeric vector of low prices.}

\item{close}{numeric vector of close prices.}

\item{width}{if an integer, the width of the rolling window. If a vector with the same length of the input prices, the width of the window corresponding to each observation. Otherwise, a vector of endpoints. See examples.}

\item{sign}{whether to return signed estimates.}

\item{na.rm}{whether to ignore missing values.}
}
\value{
Vector of spread estimates. 
A value of 0.01 corresponds to a spread of 1\%.
This function always returns a result of the same length as the input prices.
}
\description{
Implements a rolling window calculation of the efficient estimator of bid-ask spreads 
from open, high, low, and close prices described in Ardia, Guidotti, & Kroencke (JFE, 2024):
\doi{10.1016/j.jfineco.2024.103916}.
}
\details{
Prices must be sorted in ascending order of the timestamp.
}
\examples{
# reduce number of threads to pass CRAN checks (you can ignore this)
data.table::setDTthreads(1)

# simulate open, high, low, and close prices with spread 1\%
x <- sim(n = 1000, spread = 0.01)

# estimate the spread using a rolling window
s <- edge_rolling(x$Open, x$High, x$Low, x$Close, width = 21)
tail(s)

# estimate the spread using custom endpoints
ep <- c(3, 35, 100)
s <- edge_rolling(x$Open, x$High, x$Low, x$Close, width = ep)
s[c(35, 100)]
# equivalent to
edge(x$Open[3:35], x$High[3:35], x$Low[3:35], x$Close[3:35])
edge(x$Open[35:100], x$High[35:100], x$Low[35:100], x$Close[35:100])

# estimate the spread using an expanding window
s <- edge_rolling(x$Open, x$High, x$Low, x$Close, width = 1:nrow(x))
tail(s)
# equivalent to
s <- edge_expanding(x$Open, x$High, x$Low, x$Close, na.rm = FALSE)
tail(s)

}
\references{
Ardia, D., Guidotti, E., Kroencke, T.A. (2024). Efficient Estimation of Bid-Ask Spreads from Open, High, Low, and Close Prices. Journal of Financial Economics, 161, 103916. 
\doi{10.1016/j.jfineco.2024.103916}
}
