% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.benchmark}
\alias{plot.benchmark}
\title{Plot method for the \code{benchmark} timings.}
\usage{
\method{plot}{benchmark}(x, units = "auto", log = TRUE, xlab, ylab, ...)
}
\arguments{
\item{x}{An object of class \code{benchmark}.}

\item{units}{Character. The units to be used in printing the timings.
The available units are nanoseconds (\code{"ns"}), microseconds
(\code{"us"}), milliseconds (\code{"ms"}), seconds (\code{"s"}).}

\item{log}{Logical. Should times be plotted on log scale?}

\item{xlab}{Character. X axis label.}

\item{ylab}{Character. Y axis label.}

\item{\dots}{Not currently used.}
}
\description{
Displays measurement results as a scatter plot, with R expressions on X axis
and execution time on Y axis. Each expression is highlighted by its own colour.
}
\details{
If \code{ggplot2} package is available, it will be used. In order to switch to default
\code{boxplot} from the \code{graphics} package set option \code{benchr.use_ggplot}
to \code{FALSE}: \code{options(benchr.use_ggplot = FALSE)}.
}
\examples{
timings <- benchmark(
  rchisq(100, 0), rchisq(100, 1), rchisq(100, 2),
  rchisq(100, 3), rchisq(100, 5),
  times = 1000L
)
plot(timings)
}
\seealso{
\code{\link[=boxplot.benchmark]{boxplot.benchmark()}}
}
\author{
Artem Klevtsov \email{a.a.klevtsov@gmail.com}
}
