% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeCensored.R
\name{imputeDF}
\alias{imputeDF}
\title{Impute Censored Values in dataframes}
\usage{
imputeDF(df, imputeOption = "mid")
}
\arguments{
\item{df}{dataframe}

\item{imputeOption}{imputation method [default= "mid"], valid impute options
are "lower", "upper", "mid", "norm", "lnorm"}
}
\value{
dataframe where fields with censored data (i.e., Surv objects) are
  transformed into a simple numeric fields
}
\description{
Impute value for multiply censored data in data frames
}
\details{
The imputeOption values of \code{"lower"}, \code{"upper"} and \code{"mid"}
impute the lower limit, upper limit, and midpoint between the lower and upper
limit. In the context of typical water quality data, these options would be
equivalent to zero, detection limit and 1/2 detection limit substitution.
Options for substituting the normal [\code{"norm"}] or lognormal
[\code{"lnorm"}] expectation can also be used.
}
\examples{
\dontrun{
df  <- dataCensored[1:20, ]
df.lower <- imputeDF(df,'lower')
df.mid   <- imputeDF(df,'mid')
df.upper <- imputeDF(df,'upper')
df.norm  <- imputeDF(df,'norm')
df.lnorm <- imputeDF(df,'lnorm')
}
}
\seealso{
\code{\link{makeSurvDF}},  \code{\link{unSurvDF}}
,  \code{\link{unSurv}},  \code{\link{impute}},  \code{\link{imputeDF}},
}
