% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newCppModel.R
\name{getCppModelParams}
\alias{getCppModelParams}
\title{Extract Model Parameters from C++ Model Object}
\usage{
getCppModelParams(model)
}
\arguments{
\item{model}{A C++ model object created with \code{newCppModel()}}
}
\value{
A named list containing all model parameter values:
\itemize{
\item \code{Insitu} - Named numeric vector of in situ parameter values
\item \code{SurveillanceTest} - Named numeric vector of surveillance test parameter values
\item \code{ClinicalTest} - Named numeric vector of clinical test parameter values
\item \code{OutCol} - Named numeric vector of out-of-unit colonization parameter values
\item \code{InCol} - Named numeric vector of in-unit colonization parameter values
\item \code{Abx} - Named numeric vector of antibiotic parameter values (if applicable)
}

If a component's names cannot be determined or lengths mismatch, the vector
is returned unnamed.
}
\description{
Convenience function to extract all parameter values from a C++ model object
created with \code{newCppModel()}. This is essentially a wrapper around accessing
the model's parameter properties.
}
\examples{
\donttest{
# Create a linear antibiotic model
params <- LinearAbxModel()
model <- newCppModel(params)

# Extract all parameters
all_params <- getCppModelParams(model)

# View specific parameter groups
all_params$InCol  # In-unit colonization parameters
all_params$Insitu # In situ parameters
}
}
