#' Simulated Transmission Data
#'
#' This data set contains simulated transmission data for a hypothetical infectious disease. The data set contains the following columns:
#'
#' * `facility`: The facility where the event occurred.
#' * `unit`: The unit within the facility where the event occurred.
#' * `time`: The time at which the event occurred.
#' * `patient`: The patient involved in the event.
#' * `type`: The type of event.
#'
"simulated.data"

#' Simulated Transmission Data (Sorted)
#'
#' This is a sorted version of the simulated transmission data. The data is sorted by time, then by patient.
#' See \code{\link{simulated.data}} for column descriptions.
#'
"simulated.data_sorted"
