% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.pmmh_output}
\alias{summary.pmmh_output}
\title{Summary method for PMMH output}
\usage{
\method{summary}{pmmh_output}(object, ...)
}
\arguments{
\item{object}{An object of class `pmmh_output`.}

\item{...}{Additional arguments.}
}
\value{
A data frame containing summary statistics for each parameter.
}
\description{
This function returns summary statistics for PMMH output objects, including
means, standard deviations, medians, credible intervals, and diagnostics.
}
\examples{
# Create dummy chains for two parameters across two chains
chain1 <- data.frame(param1 = rnorm(100), param2 = rnorm(100), chain = 1)
chain2 <- data.frame(param1 = rnorm(100), param2 = rnorm(100), chain = 2)
dummy_output <- list(
  theta_chain = rbind(chain1, chain2),
  diagnostics = list(
    ess = c(param1 = 200, param2 = 190),
    rhat = c(param1 = 1.01, param2 = 1.00)
  )
)
class(dummy_output) <- "pmmh_output"
summary(dummy_output)
}
