basetheme_default <- function() {
  palette <- c("black", "red", "green3", "blue", "cyan", "magenta", "yellow", "gray")
  list(fg           = "black",
       adj          = 0.5,
       ann          = TRUE,
       bg           = "transparent",
       bty          = "o",
       cex          = 1,
       cex.axis     = 1,
       cex.lab      = 1,
       cex.main     = 1.2,
       cex.sub      = 1,
       col          = "black",
       col.axis     = "black",
       col.lab      = "black",
       col.main     = "black",
       col.sub      = "black",
       family       = "",
       font         = 1,
       font.axis    = 1,
       font.lab     = 1,
       font.main    = 2,
       font.sub     = 1,
       lab          = c(5, 5, 7),
       las          = 0,
       lend         = "round",
       ljoin        = "round",
       lmitre       = 10,
       lty          = "solid",
       lwd          = 1,
       mgp          = c(3, 1, 0),
       pch          = 1,
       tck          = NA,
       xaxs         = "r",
       xaxt         = "s",
       xpd          = FALSE,
       yaxs         = "r",
       yaxt         = "s",
       rect.col     = NA,
       rect.density = numeric(),
       rect.angle   = 45,
       rect.lwd     = 1,
       rect.lty     = 1,
       rect.border  = NA,
       palette      = palette
       )
}


basetheme_minimal <- function() {
  palette <- c("grey15", "red", "limegreen", "cornflowerblue", "orange")
  list(fg           = "black",
       adj          = 0.5,
       ann          = TRUE,
       bg           = "white",
       bty          = "n",
       cex          = 1,
       cex.axis     = 0.8,
       cex.lab      = 1,
       cex.main     = 1.2,
       cex.sub      = 1,
       col          = "black",
       col.axis     = "black",
       col.lab      = "black",
       col.main     = "black",
       col.sub      = "black",
       family       = "serif",
       font         = 1,
       font.axis    = 1,
       font.lab     = 1,
       font.main    = 2,
       font.sub     = 2,
       lab          = c(5,5,7),
       las          = 1,
       lend         = 0,
       ljoin        = 0,
       lmitre       = 10,
       lty          = 1,
       lwd          = 1,
       mgp          = c(2,0.7,0),
       pch          = 20,
       tck          = -0.01,
       xaxs         = "r",
       xaxt         = "s",
       xpd          = FALSE,
       yaxs         = "r",
       yaxt         = "s",
       rect.col     =  NA,
       rect.density =  numeric(),
       rect.angle   =  45,
       rect.lwd     =  1,
       rect.lty     =  1,
       rect.border  =  NA,
       palette      =  palette
       )
}


basetheme_void <- function() {
  palette <- c("black", "red", "limegreen")
  list(fg           = "black",
       adj          = 0.5,
       ann          = FALSE,
       bg           = "white",
       bty          = "n",
       cex          = 0.8,
       cex.axis     = 0.8,
       cex.lab      = 1,
       cex.main     = 1.2,
       cex.sub      = 1,
       col          = "black",
       col.axis     = "black",
       col.lab      = "black",
       col.main     = "black",
       col.sub      = "black",
       family       = "",
       font         = 1,
       font.axis    = 1,
       font.lab     = 1,
       font.main    = 2,
       font.sub     = 2,
       lab          = c(5,5,7),
       las          = 1,
       lend         = 0,
       ljoin        = 0,
       lmitre       = 10,
       lty          = 1,
       lwd          = 2,
       mgp          = c(2,0.5,0),
       pch          = 19,
       tck          = -0.01,
       xaxs         = "i",
       xaxt         = "n",
       xpd          = FALSE,
       yaxs         = "i",
       yaxt         = "n",
       rect.col     =  NA,
       rect.density =  numeric(),
       rect.angle   =  45,
       rect.lwd     =  1,
       rect.lty     =  1,
       rect.border  =  NA,
       palette      =  palette
       )
}


basetheme_brutal <- function() {
  palette <- c("#3b4252", "#bf616a", "#8fa87a", "#5e81ac", "#d08770")
  list(fg           = "#3b4252",
       adj          = 0.5,
       ann          = TRUE,
       bg           = "white",
       bty          = "o",
       cex          = 1,
       cex.axis     = 1.2,
       cex.lab      = 1.5,
       cex.main     = 2,
       cex.sub      = 1.5,
       col          = "#3b4252",
       col.axis     = "#3b4252",
       col.lab      = "#3b4252",
       col.main     = "#3b4252",
       col.sub      = "#3b4252",
       family       = "mono",
       font         = 2,
       font.axis    = 1,
       font.lab     = 2,
       font.main    = 2,
       font.sub     = 2,
       lab          = c(4,4,7),
       las          = 1,
       lend         = 0,
       ljoin        = 0,
       lmitre       = 10,
       lty          = 1,
       lwd          = 4,
       mgp          = c(2.5,0.25,0),
       pch          = 15,
       tck          = 0,
       xaxs         = "r",
       xaxt         = "s",
       xpd          = FALSE,
       yaxs         = "r",
       yaxt         = "s",
       rect.col     =  NA,
       rect.density =  numeric(),
       rect.angle   =  45,
       rect.lwd     =  4,
       rect.lty     =  1,
       rect.border  =  NA,
       palette      =  palette
       )
}


basetheme_clean <- function() {
  palette <- c("#4D4D4D", "#5DA5DA", "#FAA43A", "#60BD68", "#F15854", "#B276B2",
               "#DECF3F", "#F17CB0", "#B2912F", "#c29bff", "#fff68f", "#85f9d6",
               "#a6cc7a", "#8d0808", "#8d7b88", "#461e78", "#f8b1cc", "#800080",
               "#79c7ad", "#34bdcc", "#c3fbc4", "#baadb5", "#440a4f", "#dfff7b",
               "#4f61a1", "#4afff0"
               )
  list(fg           = "black",
       adj          = 0.5,
       ann          = TRUE,
       bg           = "white",
       bty          = "o",
       cex          = 1,
       cex.axis     = 0.7,
       cex.lab      = 0.8,
       cex.main     = 1,
       cex.sub      = 0.8,
       col          = "black",
       col.axis     = "black",
       col.lab      = "black",
       col.main     = "black",
       col.sub      = "black",
       family       = "",
       font         = 1,
       font.axis    = 1,
       font.lab     = 1,
       font.main    = 2,
       font.sub     = 3,
       lab          = c(5, 5, 7),
       las          = 1,
       lend         = "round",
       ljoin        = "round",
       lmitre       = 10,
       lty          = "solid",
       lwd          = 1,
       mgp          = c(2, 0.5, 0),
       pch          = 20,
       tck          = -0.01,
       xaxs         = "r",
       xaxt         = "s",
       xpd          = FALSE,
       yaxs         = "r",
       yaxt         = "s",
       rect.col     = NA,
       rect.density = numeric(),
       rect.angle   = 45,
       rect.lwd     = 1,
       rect.lty     = 1,
       rect.border  = NA,
       palette      = palette
       )
}


basetheme_ink <- function() {
  palette <- c("blue", "red", "green4", "darkorange", "purple",
               "gold", "deeppink2", "lightslategrey"
               )
  list(fg           = "blue",
       adj          = 0.5,
       ann          = TRUE,
       bg           = "navajowhite",
       bty          = "o",
       cex          = 0.8,
       cex.axis     = 1,
       cex.lab      = 1,
       cex.main     = 1.5,
       cex.sub      = 1,
       col          = "blue",
       col.axis     = "blue",
       col.lab      = "blue",
       col.main     = "blue",
       col.sub      = "blue",
       family       = "",
       font         = 3,
       font.axis    = 3,
       font.lab     = 4,
       font.main    = 2,
       font.sub     = 3,
       lab          = c(5, 5, 7),
       las          = 1,
       lend         = "round",
       ljoin        = "round",
       lmitre       = 10,
       lty          = "dotted",
       lwd          = 2,
       mgp          = c(2, 0.5, 0),
       pch          = 4,
       tck          = -0.01,
       xaxs         = "r",
       xaxt         = "s",
       xpd          = FALSE,
       yaxs         = "r",
       yaxt         = "s",
       rect.col     = "gray80",
       rect.density = 10,
       rect.angle   = 45,
       rect.lwd     = 1,
       rect.lty     = 1,
       rect.border  = NA,
       palette      = palette
       )
}


basetheme_dark <- function() {
  palette <- c("#3870C2", "#8AC1D4", "#F2A83B", "#FFFD55", "#66C84D",
               "#A6EB99", "#DA2E20", "#EB8677", "#8825CB", "#DF89E8"
               )
  list(fg           = "#7E848C",
       adj          = 0.5,
       ann          = TRUE,
       bg           = "#2E3947",
       bty          = "n",
       cex          = 0.8,
       cex.axis     = 1,
       cex.lab      = 1,
       cex.main     = 1.5,
       cex.sub      = 1,
       col          = "#BEBEBE",
       col.axis     = "#7E848C",
       col.lab      = "#BEBEBE",
       col.main     = "#EFF0F2",
       col.sub      = "#737D89",
       family       = "",
       font         = 1,
       font.axis    = 1,
       font.lab     = 2,
       font.main    = 2,
       font.sub     = 3,
       lab          = c(5, 5, 7),
       las          = 1,
       lend         = "round",
       ljoin        = "round",
       lmitre       = 10,
       lty          = 1,
       lwd          = 1,
       mgp          = c(3, 0.7, 0),
       pch          = 19,
       tck          = -0.01,
       xaxs         = "r",
       xaxt         = "s",
       xpd          = FALSE,
       yaxs         = "r",
       yaxt         = "s",
       rect.col     = NA,
       rect.density = numeric(),
       rect.angle   = 45,
       rect.lwd     = 1,
       rect.lty     = 1,
       rect.border  = NA,
       palette      = palette
       )
}

list_themes <- function() {
  c(brutal  = basetheme_brutal,
    clean   = basetheme_clean,
    default = basetheme_default,
    ink     = basetheme_ink,
    minimal = basetheme_minimal,
    dark    = basetheme_dark,
    void    = basetheme_void
    )
}
