% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda.R
\name{get_top_pattern}
\alias{get_top_pattern}
\title{get top patterns from a slice of bronze-standard measurement}
\usage{
get_top_pattern(BrS_dat, Y, case_status, n_pat, exclude_missing = TRUE)
}
\arguments{
\item{BrS_dat}{bronze-standard data, which is usually \code{data_nplcm$Mobs$MBS[[1]]}}

\item{Y}{A vector of case/control status: 1 for case; 0 for control}

\item{case_status}{1 for case; 0 for controls}

\item{n_pat}{the number of top patterns one wants to show}

\item{exclude_missing}{DEFAULT is TRUE for excluding any individual with missing measurements.}
}
\value{
a list of results: \code{obs_pat} - observed rates;
\code{pattern_names}; \code{exist_other} - if
actual no. of patterns is larger than \code{n_pat}; \code{N}- No. of individuals
with \code{Y = case_status}.
}
\description{
get top patterns from a slice of bronze-standard measurement
}
\examples{

data(data_nplcm_noreg)
get_top_pattern(data_nplcm_noreg$Mobs$MBS[[1]],data_nplcm_noreg$Y,1,5,FALSE)

data(data_nplcm_noreg)
get_top_pattern(data_nplcm_noreg$Mobs$MBS$MBS1,data_nplcm_noreg$Y,case_status=1,n_pat=5)


}
\seealso{
Other exploratory data analysis functions: 
\code{\link{plot_logORmat}()},
\code{\link{show_individual}()},
\code{\link{summarize_BrS}()},
\code{\link{summarize_SS}()},
\code{\link{visualize_season}()}
}
\concept{exploratory data analysis functions}
