% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage-package.R
\docType{package}
\name{bage-package}
\alias{bage}
\alias{bage-package}
\title{Package 'bage'}
\description{
Bayesian estimation and forecasting of age-specific rates.
Estimation uses \href{https://CRAN.R-project.org/package=TMB}{TMB},
and is fast.
}
\section{Example workflow}{

\enumerate{
\item Specify model using \code{\link[=mod_pois]{mod_pois()}}
\item Fit model using \code{\link[=fit]{fit()}}
\item Extract results using \code{\link[=augment]{augment()}}
\item Check model using \code{\link[=replicate_data]{replicate_data()}}
}
}

\section{Functions}{


\strong{Specify model}
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify a normal model
\item \code{\link[=set_prior]{set_prior()}} Specify prior for main effect or interaction
\item \link{priors} List of available priors for main effects or interactions
\item \code{\link[=set_disp]{set_disp()}} Specify prior for dispersion/variance
\item \code{\link[=set_var_age]{set_var_age()}} Identify age variable in data
\item \code{\link[=set_var_sexgender]{set_var_sexgender()}} Identify sex or gender variable in data
\item \code{\link[=set_var_time]{set_var_time()}} Identify time variable in data
}

\strong{Fit model}
\itemize{
\item \code{\link[=fit]{fit()}} Derive posterior distribution
\item \code{\link[=is_fitted]{is_fitted()}} See if model has been fitted
}

\strong{Extract results}
\itemize{
\item \code{\link[=augment]{augment()}} Add cell-level estimates to data
\item \link[=components.bage_mod]{components()} Hyper-parameters
\item \code{\link[=tidy]{tidy()}} One-line summary
\item \code{\link[=set_n_draw]{set_n_draw()}} Specify number of prior or posterior draws
}

\strong{Forecast}
\itemize{
\item \code{\link[=forecast]{forecast()}} Use model to obtain estimates for future periods
}

\strong{Check model}
\itemize{
\item \code{\link[=replicate_data]{replicate_data()}} Compare real and simulated data
\item \code{\link[=report_sim]{report_sim()}} Simulation study of model
}

\strong{SVD-based modelling of age profiles}
\itemize{
\item \link[=components.bage_ssvd]{components()} Matrices and offsets from scaled SVD
\item \link[=generate.bage_ssvd]{generate()} Random profiles
\item \link{HFD} Scaled SVD of fertility rates from Human Fertility Database
\item \link{HMD} Scaled SVD of mortality rates from Human Mortality Database
\item \link{LFP} Scaled SVD of labor force participation rates from OECD
}

\strong{Data}
\itemize{
\item \link{isl_deaths} Deaths in Iceland
\item \link{kor_births} Births in South Korea
\item \link{nld_expenditure} Health expenditure in the Netherlands
\item \link{nzl_divorces} Divorces in New Zealand
\item \link{nzl_households} One-person households in New Zealand
\item \link{nzl_injuries} Fatal injuries in New Zealand
\item \link{swe_infant} Infant mortality in Sweden
\item \link{usa_deaths} Accidental deaths in the USA
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://bayesiandemography.github.io/bage/}
  \item \url{https://github.com/bayesiandemography/bage}
  \item Report bugs at \url{https://github.com/bayesiandemography/bage/issues}
}

}
\author{
\strong{Maintainer}: John Bryant \email{john@bayesiandemography.com}

Authors:
\itemize{
  \item Junni Zhang \email{junnizhang@163.com}
}

Other contributors:
\itemize{
  \item Bayesian Demography Limited [copyright holder]
}

}
\keyword{internal}
