% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_commit_empty}
\alias{am_commit_empty}
\title{Create an empty change}
\usage{
am_commit_empty(doc, message = NULL, time = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{message}{Optional commit message (character string)}

\item{time}{Optional timestamp (POSIXct). If \code{NULL}, uses current time.}
}
\value{
The document \code{doc} (invisibly)
}
\description{
Creates a new change in the document's history without any operations.
This is useful for creating merge commits or recording metadata
(message, timestamp) without making data changes.
}
\examples{
doc <- am_create()
doc$key <- "value"
am_commit(doc, "Initial data")

# Create empty change as a checkpoint
am_commit_empty(doc, "Checkpoint")

am_close(doc)

}
