% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_close}
\alias{am_close}
\title{Close an Automerge document}
\usage{
am_close(doc)
}
\arguments{
\item{doc}{An Automerge document (created with \code{am_create()} or \code{am_load()})}
}
\value{
\code{NULL} (invisibly)
}
\description{
Explicitly frees the resources associated with an Automerge document.
After calling this function, the document becomes invalid and should
not be used.
}
\details{
This function is useful when you need deterministic cleanup rather than
waiting for garbage collection. It is safe to call on a document that
has already been closed.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")

# Explicitly free resources
am_close(doc)

# Document is now invalid - do not use after closing

}
