% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_seq}
\alias{am_change_seq}
\title{Get the sequence number of a change}
\usage{
am_change_seq(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}},
\code{\link[=am_get_changes]{am_get_changes()}}, or \code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
A numeric value (double, since sequence numbers can exceed R's
32-bit integer range)
}
\description{
Returns the sequence number of the change within its actor's history.
Sequence numbers start at 1 and increment with each change by the
same actor.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "x", 1)
am_commit(doc, "First")
am_put(doc, AM_ROOT, "y", 2)
am_commit(doc, "Second")

history <- am_get_changes(doc)
am_change_seq(history[[1]])  # 1
am_change_seq(history[[2]])  # 2

am_close(doc)

}
