% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{am_delete_path}
\alias{am_delete_path}
\title{Delete value at path}
\usage{
am_delete_path(doc, path)
}
\arguments{
\item{doc}{An Automerge document}

\item{path}{Character vector, numeric vector, or list of mixed types
specifying the path to the value to delete}
}
\value{
The document (invisibly)
}
\description{
Delete a value from an Automerge document using a path vector.
}
\examples{
doc <- am_create()
am_put_path(doc, c("user", "address", "city"), "NYC")
am_put_path(doc, c("user", "name"), "Alice")

# Delete nested key
am_delete_path(doc, c("user", "address"))

# Address should be gone
am_get_path(doc, c("user", "address"))  # NULL

am_close(doc)

}
