% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normTable.R
\name{normTable}
\alias{normTable}
\title{Normalise data tables}
\usage{
normTable(
  input = NULL,
  ...,
  source = "tabID",
  pattern = NULL,
  update = FALSE,
  keepOrig = FALSE,
  outType = "rds",
  verbose = FALSE
)
}
\arguments{
\item{input}{[\code{character(1)}]\cr path of the file to normalise. If this
is left empty, all files at stage two as subset by \code{pattern} are
chosen}

\item{...}{[\code{list(.)}]\cr matching lists that capture the variables by
which to match and the new column names containing the resulting ID; see
Details.}

\item{source}{[\code{charcter(1)}]\cr the source from which translations of
terms should be sought. By default the recent \code{"tabID"}, but when the
same terms occur in several tables of a dataseries, chose \code{"datID"}.}

\item{pattern}{[\code{character(1)}]\cr an optional regular expression. Only
dataset names which match the regular expression will be returned.}

\item{update}{[\code{logical(1)}]\cr whether or not the physical files should
be updated (\code{TRUE}) or the function should merely return the new
object (\code{FALSE}, default). This is helpful to check whether the
metadata specification and the provided file(s) (translation and ID tables)
are properly specified.}

\item{keepOrig}{[\code{logical(1)}]\cr to keep the original units and
variable names in the output (\code{TRUE}) or to remove them (\code{FALSE},
default). Useful for debugging.}

\item{outType}{[\code{logical(1)}]\cr the output file-type, currently
implemented options are either \emph{*.csv} (more exchangeable for a
workflow based on several programs) or \emph{*.rds} (smaller and less
error-prone data-format but can only be read by R efficiently).}

\item{verbose}{[\code{logical(1)}]\cr be verbose about translating terms
(default \code{FALSE}). Furthermore, you can use
\code{\link{suppressMessages}} to make this function completely silent.}
}
\value{
This function harmonises and integrates so far unprocessed data
  tables at stage two into stage three of the areal database. It produces for
  each nation in the registered data tables a comma-separated values file
  that includes all thematic areal data.
}
\description{
Harmonise and integrate data tables into standardised format
}
\details{
Arguments in \code{...} are so-called matching lists. This argument
  captures three kinds of information: \enumerate{\item the 'variable' that
  should be matched with a matching list, \item the 'targetColumn' in that
  matching list that should be included in the final table in the place of
  'variable' and \item the 'targetID' (column name) of that new variable.}

  targetID = list(variable = targetColumn)

  'variable' must be present as column in \code{input} and a table that is
  named "id_variable.csv" (where 'variable' is replaced by the variable name)
  must be available in the root directory of the project. This should have
  been created with \code{\link{setVariables}}.

  To normalise data tables, this function proceeds as follows: \enumerate{
  \item Read in \code{input} and extract initial metadata from the file name.
  \item Employ the function \code{tabshiftr::\link{reorganise}} to reshape
  \code{input} according to the respective schema description. \item Match
  the territorial units in \code{input} via \code{\link{matchUnits}}. \item
  If \code{...} has been provided with variables to match, those are matched
  via \code{\link{matchVars}}. \item Harmonise territorial unit names. \item
  If \code{update = TRUE}, store the processed data table at stage three.}
}
\examples{
# build the example database
makeExampleDB(until = "normGeometry")

# normalise all available data tables, harmonising commodities
# according to the FAO commodity list ...
normTable(faoID = list(commodities = "target"), update = TRUE)

# ... and check the result
output <- readRDS(paste0(tempdir(), "/newDB/adb_tables/stage3/Estonia.rds"))
}
\seealso{
Other normalisers: 
\code{\link{normGeometry}()}
}
\concept{normalisers}
