% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pod_analysis.R
\name{plot_metaregression_spaghetti_plot}
\alias{plot_metaregression_spaghetti_plot}
\title{Make a spaghetti plot for the metaregression results}
\usage{
plot_metaregression_spaghetti_plot(bootstrap_metaregression_obj,
  number_to_plot = 100)
}
\arguments{
\item{bootstrap_metaregression_obj}{the object that contains the bootstrap
metaregression models as a \code{bmr} object.}

\item{number_to_plot}{the number of bootstrap metaregression
concentration-response models to plot. The default is 100 models.}
}
\description{
Plots a subset of the metaregression results.
}
\details{
This function plots the concentration-response curves for a subset of the
metaregression models generated.
}
\examples{
bmr_obj <- bootstrap_metaregression(oxybenzone, 15, 100)
plot_metaregression_spaghetti_plot(bmr_obj, number_to_plot=40)
}

