% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aop_graph_analysis.R
\name{convert_cytoscape_to_aop}
\alias{convert_cytoscape_to_aop}
\title{Convert Cytoscape Graph to an AOP}
\usage{
convert_cytoscape_to_aop(file)
}
\arguments{
\item{file}{a Cytoscape JSON file.}
}
\value{
aop a \code{aop_cytoscape-class} object.
}
\description{
Converts a cytoscape JSON file to an \code{aop_cytoscape-class} object.
}
\details{
This function converts a JSON file exported from Cytoscape into a
\code{aop_cytoscape-class} object. Once an \code{aop_cytoscape-class}
object, we can perform conversion to a \code{graphNEL} object, and then
perform graph-based analyses.
}
\examples{
steatosis_json_file <- system.file("extdata", "steatosis_aop_json.cyjs",
package = "aop")
steatosis_aop <- convert_cytoscape_to_aop(steatosis_json_file)
}

