% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modifications}
\alias{modifications}
\alias{blend}
\alias{normalise}
\alias{normalize}
\alias{cap}
\title{Simply value modifications}
\usage{
blend(x, y, mask)

normalise(x, from = range(x), to = c(0, 1))

normalize(x, from = range(x), to = c(0, 1))

cap(x, lower = 0, upper = 1)
}
\arguments{
\item{x, y}{Values to modify}

\item{mask}{A vector of the same length as \code{x} and \code{y}. Assumed to be between
0 and 1 (values outside of this range is capped). The closer to 1 the more of
\code{x} will be used and the closer to 0 the more of \code{y} will be used}

\item{from}{The range of \code{x} to use for normalisation}

\item{to}{The output domain to normalise to}

\item{lower, upper}{The lower and upper bounds to cap to}
}
\description{
Most modifications of values in a long_grid are quite simple due to the
wealth of vectorised functions avaliable in R. ambient provides a little
selection of handy functions to compliment these
}
\examples{
grid <- long_grid(seq(1, 10, length.out = 1000), seq(1, 10, length.out = 1000))
grid$chess <- gen_checkerboard(grid$x, grid$y)
grid$noise <- gen_perlin(grid$x, grid$y)
grid$ripple <- gen_waves(grid$x, grid$y)

# Blend two values based on a third
grid$mix <- blend(grid$noise, grid$ripple, grid$chess)
plot(grid, mix)

# Cap values between 0 and 1
plot(grid, cap(noise))

}
