% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{cinpv}
\alias{cinpv}
\title{Diagnostic performance: Confidence interval for negative predictive value}
\usage{
cinpv(roc, npv, prevalence, boot.n, quantiles = c(0.5, 0.025, 0.975), ...)
}
\arguments{
\item{roc}{Object of class pROC.}

\item{npv}{Negative predictive value.}

\item{prevalence}{Prevalence of the endpoint in the study population.}

\item{boot.n}{Number of bootstrap replicates. Default: 2000.}

\item{quantiles}{Quantiles. Default: c(0.5,.025,.975).}

\item{...}{Not used.}
}
\value{
A numeric vector of length 3 containing the median, lower bound, and
upper bound of the confidence interval.
}
\description{
This function computes a confidence interval for the negative predictive value
from a ROC curve, given the prevalence of the negative outcome.
}
\details{
This function computes a confidence interval for the negative predictive value
from a ROC curve, given the prevalence of the negative outcome.
The confidence interval is computed using bootstrap resampling.
}
