% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_build.R
\name{cm_build}
\alias{cm_build}
\title{Build a Calculated Metric}
\usage{
cm_build(
  name = NULL,
  description = NULL,
  formula = NULL,
  seg_filter = NULL,
  polarity = "positive",
  precision = 0,
  type = "decimal",
  create_cm = FALSE,
  tagNames = NULL,
  internal = FALSE,
  debug = FALSE,
  rsid = Sys.getenv("AW_REPORTSUITE_ID"),
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{name}{This is the name of the new calculated metric (required)}

\item{description}{This is the description of the segment (optional)}

\item{formula}{Formulas are list objects created using the \code{\link[=cm_formula]{cm_formula()}} function.}

\item{seg_filter}{A segment filter to be added to a metric in the formula}

\item{polarity}{Also known as 'Show Upward Trend As' in the UI. Options include 'positive' (default) or 'negative'.
This metric polarity setting shows whether Analytics should consider an upward trend in the metric as good (green) or bad (red).
As a result, the report’s graph will show as green or red when it’s going up.}

\item{precision}{Shows how many decimal places will be shown in the report.
The maximum number of decimal places you can specify is 10. Also known as 'Decimal Places' in the UI.
Default is \code{0}. Must be a numeric.}

\item{type}{Choices include Decimal (default), Time, Percent, and Currency. Also known as 'Format' in the UI.}

\item{create_cm}{Used to determine if the segment should be created in the
report suite or if the definition should be returned to be validated using cm_validate.
Default is FALSE}

\item{tagNames}{Apply tag names to the newly created calculated metric. Single string or a vector.}

\item{internal}{Determines if this segment is to be available in the UI.
Default is FALSE, meaning the segment will not be available in the UI, nor will
the ID be available in the \code{aw_get_segments} function call.}

\item{debug}{This enables the api call information to show in the console for
help with debugging issues. default is FALSE}

\item{rsid}{Adobe report suite ID (RSID).  If an environment variable called
\code{AW_REPORTSUITE_ID} exists in \code{.Renviron} or elsewhere and no \code{rsid} argument
is provided, then the \code{AW_REPORTSUITE_ID} value will be used. Use \code{\link[=aw_get_reportsuites]{aw_get_reportsuites()}}
to get a list of available \code{rsid} values.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID}
exists in \code{.Renviron} or elsewhere and no \code{company_id} argument is provided,
then the \code{AW_COMPANY_ID} value will be used. Use \code{\link[=get_me]{get_me()}} to get a list of
available \code{company_id} values.}
}
\value{
If the "create_cm" argument is set to FALSE a list object definition
will be returned. If the "create_cm" argument is set to TRUE and the calculated metric
is valid it will return a data frame of the newly created calculated metric id along
with some other basic meta data. If it returns an error then the error
response will be returned to help understand what needs to be corrected.
}
\description{
This function combines formulas to create calculated metrics in Adobe Analytics
}
\details{
See more information \href{https://experienceleague.adobe.com/en/docs/analytics/components/calculated-metrics/calcmetric-workflow/cm-build-metrics}{here}
}
