% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_relative_flag.R
\name{derive_var_relative_flag}
\alias{derive_var_relative_flag}
\title{Flag Observations Before or After a Condition is Fulfilled}
\usage{
derive_var_relative_flag(
  dataset,
  by_vars,
  order,
  new_var,
  condition,
  mode,
  selection,
  inclusive,
  flag_no_ref_groups = TRUE,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} and \code{order} arguments are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

\describe{
\item{Default value}{none}
}}

\item{order}{Sort order

Within each by group the observations are ordered by the specified order.

For handling of \code{NA}s in sorting variables see the "Sort Order" section in \code{vignette("generic")}.

\describe{
\item{Permitted values}{list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))}}
\item{Default value}{none}
}}

\item{new_var}{New variable

The variable is added to the input dataset and set to \code{"Y"} for all
observations before or after the condition is fulfilled. For all other
observations it is set to \code{NA}.

\describe{
\item{Default value}{none}
}}

\item{condition}{Condition for Reference Observation

The specified condition determines the reference observation. In the output
dataset all observations before or after (\code{selection} argument)
the reference observation are flagged.

\describe{
\item{Default value}{none}
}}

\item{mode}{Selection mode (first or last)

If \code{"first"} is specified, for each by group the observations before or
after (\code{selection} argument) the observation where the condition
(\code{condition} argument) is fulfilled the \emph{first} time is flagged in the
output dataset. If \code{"last"} is specified, for each by group the
observations before or after (\code{selection} argument) the observation where
the condition (\code{condition} argument) is fulfilled the \emph{last} time is
flagged in the output dataset.

\describe{
\item{Permitted values}{\code{"first"}, \code{"last"}}
\item{Default value}{none}
}}

\item{selection}{Flag observations before or after the reference observation?

\describe{
\item{Permitted values}{\code{"before"}, \code{"after"}}
\item{Default value}{none}
}}

\item{inclusive}{Flag the reference observation?

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{none}
}}

\item{flag_no_ref_groups}{Should by groups without reference observation be flagged?

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{TRUE}}
}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

\describe{
\item{Permitted values}{\code{"none"}, \code{"warning"}, \code{"error"}}
\item{Default value}{\code{"warning"}}
}}
}
\value{
The input dataset with the new variable (\code{new_var}) added
}
\description{
Flag all observations before or after the observation where a specified
condition is fulfilled for each by group. For example, the function could be
called to flag for each subject all observations before the first disease
progression or to flag all AEs after a specific AE.
}
\details{
For each by group (\code{by_vars} argument) the observations before or
after (\code{selection} argument) the observations where the condition
(\code{condition} argument) is fulfilled the first or last time (\code{order}
argument and \code{mode} argument) is flagged in the output dataset.
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)

# Flag all AEs after the first COVID AE
adae <- tribble(
  ~USUBJID, ~ASTDY, ~ACOVFL, ~AESEQ,
  "1",           2, NA,           1,
  "1",           5, "Y",          2,
  "1",           5, NA,           3,
  "1",          17, NA,           4,
  "1",          27, "Y",          5,
  "1",          32, NA,           6,
  "2",           8, NA,           1,
  "2",          11, NA,           2,
)

derive_var_relative_flag(
  adae,
  by_vars = exprs(USUBJID),
  order = exprs(ASTDY, AESEQ),
  new_var = PSTCOVFL,
  condition = ACOVFL == "Y",
  mode = "first",
  selection = "after",
  inclusive = FALSE,
  flag_no_ref_groups = FALSE
)

response <- tribble(
  ~USUBJID, ~AVISITN, ~AVALC,
  "1",      0,        "PR",
  "1",      1,        "CR",
  "1",      2,        "CR",
  "1",      3,        "SD",
  "1",      4,        "NE",
  "2",      0,        "SD",
  "2",      1,        "PD",
  "2",      2,        "PD",
  "3",      0,        "SD",
  "4",      0,        "SD",
  "4",      1,        "PR",
  "4",      2,        "PD",
  "4",      3,        "SD",
  "4",      4,        "PR"
)

# Flag observations up to first PD for each patient
response \%>\%
  derive_var_relative_flag(
    by_vars = exprs(USUBJID),
    order = exprs(AVISITN),
    new_var = ANL02FL,
    condition = AVALC == "PD",
    mode = "first",
    selection = "before",
    inclusive = TRUE
  )

# Flag observations up to first PD excluding baseline (AVISITN = 0) for each patient
response \%>\%
  restrict_derivation(
    derivation = derive_var_relative_flag,
    args = params(
      by_vars = exprs(USUBJID),
      order = exprs(AVISITN),
      new_var = ANL02FL,
      condition = AVALC == "PD",
      mode = "first",
      selection = "before",
      inclusive = TRUE
    ),
    filter = AVISITN > 0
  ) \%>\%
  arrange(USUBJID, AVISITN)
}
\seealso{
General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_joined_exist_flag}()},
\code{\link{derive_var_merged_ef_msrc}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_merged_summary}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_vars_cat}()},
\code{\link{derive_vars_computed}()},
\code{\link{derive_vars_joined}()},
\code{\link{derive_vars_joined_summary}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_transposed}()}
}
\concept{der_gen}
\keyword{der_gen}
