% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serial.test_sh.R
\name{serial.test_sh}
\alias{serial.test_sh}
\title{Test for serially correlated errors for VAR shrinkage estimate}
\usage{
serial.test_sh(x, lags.pt = 16, lags.bg = 5,
  type = c("PT.asymptotic", "PT.adjusted", "BG", "ES"))
}
\arguments{
\item{x}{An object of class "varshrinkest" obtained by VARshrink().}

\item{lags.pt, lags.bg, type}{Other arguments for vars::serial.test().
see help(serial.test) for details.}
}
\description{
An extension of vars::serial.test() to the class "varshrinkest".
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
serial.test_sh(estim)
}
\seealso{
\code{\link[vars]{serial.test}}
}
