% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arm.R
\name{arm}
\alias{arm}
\title{Define an Arm}
\usage{
arm(name, ...)
}
\arguments{
\item{name}{character. Name of arm, which is the arm's label in generated
trial data, i.e., the one retrieved by calling \code{Trials$get_locked_data()}
in action functions.}

\item{...}{subset condition that is compatible with \code{dplyr::filter}.
This can be used to specify inclusion criteria of an arm.
By default it is not specified, i.e. all data generated by the generator
will be used as trial data. More than one conditions can be
specified in \code{...}.}
}
\description{
Define an arm in a trial. This is a user-friendly wrapper for
the class constructor \code{Arms$new()}. Users who are not familiar with
the concept of classes may consider using this wrapper directly.
}
\examples{

risk <- data.frame(
  end_time = c(1, 10, 26.0, 52.0),
  piecewise_risk = c(1, 1.01, 0.381, 0.150) * exp(-3.01)
)

pfs <- endpoint(name = 'pfs', type='tte',
generator = PiecewiseConstantExponentialRNG,
risk = risk, endpoint_name = 'pfs')

orr <- endpoint(
  name = 'orr', type = 'non-tte',
  readout = c(orr = 2), generator = rbinom,
  size = 1, prob = .4)

placebo <- arm(name = 'pbo')

placebo$add_endpoints(pfs, orr)

## try to generate some data from the arm
## it is NOT a recommended way to use the package in simulation
head(placebo$get_endpoints()[[1]]$get_generator()(n = 1e3))

## get name of endpoints in the arm
## for illustration only, NOT recommended
placebo$get_endpoints()[[2]]$get_name()

## run it in console to get summary report
## It is the recommended way to view an arm
placebo

}
