% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{univariate}
\alias{univariate}
\title{Univariate Analysis Of Sexual Dimorphism}
\usage{
univariate(
  x,
  Pop = 1,
  type_anova = "II",
  interact_anova = TRUE,
  es_anova = "none",
  pairwise = FALSE,
  padjust = "none",
  ...,
  lower.tail = FALSE,
  CI = 0.95,
  N = NULL,
  digits = 4
)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{Pop}{Number of the column containing populations' names, Default: 1}

\item{type_anova}{type of ANOVA test "I","II" or "III", Default:"II".}

\item{interact_anova}{Logical; if TRUE calculates interaction effect,
Default: TRUE.}

\item{es_anova}{Type of effect size either "f" for f squared,"eta" for eta
squared or "none", Default:"none".}

\item{pairwise}{Logical; if TRUE runs multiple pairwise comparisons on
different populations using \link{t_greene} Default: FALSE}

\item{padjust}{Method of p.value adjustment for multiple comparisons
following \link[stats]{p.adjust}  Default: "none".}

\item{...}{Additional arguments that could be passed to the \link{t_greene}
function}

\item{lower.tail}{Logical; if TRUE probabilities are `P[X <= x]`,
otherwise, `P[X > x]`., Default: FALSE}

\item{CI}{confidence interval coverage takes value from 0 to 1, Default: 0.95.}

\item{N}{Number of pairwise comparisons for [p.adjust.methods], if left
`NULL` it will follow the formula `n(n 1)/2` where `n` is the number of
populations , Default: NULL}

\item{digits}{Number of significant digits, Default: 4}
}
\value{
ANOVA tale.
}
\description{
Calculation and visualization of the differences in degree
sexual dimorphism between multiple populations using a modified one way
ANOVA and summary statistics as input
}
\details{
Data is entered as a data frame of summary statistics where
the column containing population names is chosen by position (first by
default), other columns of summary data should have specific names (case
sensitive) similar to \link{baboon.parms_df}
}
\examples{
# Comparisons of femur head diameter in four populations
library(TestDimorph)
df <-
  data.frame(
    Pop = c("Turkish", "Bulgarian", "Greek", "Portuguese "),
    m = c(150.00, 82.00, 36.00, 34.00),
    M.mu = c(49.39, 48.33, 46.99, 45.20),
    M.sdev = c(3.01, 2.53, 2.47, 2.00),
    f = c(150.00, 58.00, 34.00, 24.00),
    F.mu = c(42.91, 42.89, 42.44, 40.90),
    F.sdev = c(2.90, 2.84, 2.26, 2.90)
  )
univariate(df, pairwise = TRUE, padjust = "bonferroni")
}
