% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RawGen.R
\name{RawGen}
\alias{RawGen}
\title{Raw Data Generation By Truncated Distribution}
\usage{
RawGen(v, format = "wide", complete_cases = FALSE)
}
\arguments{
\item{v}{a data frame or a named list containing summary statistics for
different parameters}

\item{format}{The form of the resultant data frame either : \code{'long'} or
: \code{'wide'}, Default: \code{'wide'}}

\item{complete_cases}{Logical; if \code{TRUE} rows with missing values will
be removed, Default: \code{FALSE}}
}
\description{
Generates raw data from summary statistics using left truncated
  normal distribution
}
\details{
Data can be entered as a data frame,with \code{Pop} (first column by
  default) containing population names,\code{Parms} containing names of
  tested parameter(s),  .mu and .sdev containing means and standard
  deviations
  with M and F donating males and females respectively. While m&f are the
  male and female sample sizes. Data also can be entered as a list of multiple
  data frames with similar structure but different parameters are entered as
  names of the list.
}
\examples{
 # Comparison of two femur parameters in two populations
 library(TestDimorph)
 Pop <- as.factor(rep(c("Bulgarian","Greek"),2))
 Parms <- as.factor(c(rep("MXFL", 2),rep("MLD", 2)))
 m <-c(82.0,36.0,82.00,36.00)
 M.mu <- c(461.80,440.40,27.67,27.74)
 M.sdev <- c(19.9,19.6,2.21,1.79)
 f <- c(58.00,34.0,58.00,34.00)
 F.mu <- c(411.70,409.80,24.89,26.69)
 F.sdev <- c(23.2,21.4,1.78,2.42)
 df <- cbind.data.frame(Pop,Parms,m,M.mu,M.sdev,f,F.mu,F.sdev)
 RawGen(df)
}
\references{
\insertRef{HUSSEIN2019}{TestDimorph}
}
