% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aovSS.R
\name{aovSS}
\alias{aovSS}
\title{aovSS}
\usage{
aovSS(x, Pop = 1, pairwise = TRUE)
}
\arguments{
\item{x}{Data frame containing summary statistics of both sexes for two or
more populations.}

\item{Pop}{Number of the column containing populations' names, Default:
\code{1}}

\item{pairwise}{Logical; if \code{TRUE} runs multiple pairwise comparisons on
different populations using \code{Tukey HSD}, Default: \code{TRUE}}
}
\value{
Sex specific ANOVA tables and pairwise comparisons.
}
\description{
Calculates sex specific one-way ANOVA followed by \code{Tukey
  HSD} from summary statistics.
}
\details{
Data is entered in a wide format with each row representing a given
  population.\code{Pop}  (first column by default) contains population names,
  \code{.mu} and \code{.sdev} contain means and standard deviations with
  \code{M} and \code{F} donating males and females respectively. While
  \code{m}&\code{f} are the male and female sample sizes.By setting the
  option \code{pairwise} to \code{TRUE}, different pairwise combinations of
  populations can be compared with \code{Tukey HSD} post hoc test.
}
\examples{
  # Comaprisons of femur head diameter in four populations
m <- c(150.00, 82.00, 36.00, 34.00)
f <- c(150.00, 58.00, 34.00, 24.00)
M.mu <- c(49.39, 48.33, 46.99, 45.20)
F.mu <- c(42.91, 42.89, 42.44, 40.90)
M.sdev <- c(3.01, 2.53, 2.47, 2.00)
F.sdev <- c(2.90, 2.84, 2.26, 2.90)
df <- cbind.data.frame(
  Pop = c('Turkish', 'Bulgarian', 'Greek', 'Portuguese '),
  m,
  f,
  M.mu,
  F.mu,
  M.sdev,
  F.sdev,
  stringsAsFactors = TRUE
)
TestDimorph::aovSS(x = df)

}
\references{
\insertRef{timonov2014study}{TestDimorph}

  \insertRef{curate2017sex}{TestDimorph}

  \insertRef{kranioti2009sex}{TestDimorph}

  \insertRef{gulhan2015new}{TestDimorph}
}
